/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsUtils;
import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.util.Collections;
import java.util.List;

public abstract class FileIdOperationEncoder
implements Requestor.Encoder {
    private final FileId fileId;

    protected FileIdOperationEncoder(FileId fileId) {
        this.fileId = fileId;
    }

    @Override
    public List<Object> encode(ByteBufAllocator alloc) {
        byte cmd = this.cmd();
        int length = 16 + this.fileId.pathBytes().length;
        ByteBuf buf = alloc.buffer(length + 10);
        buf.writeLong((long)length);
        buf.writeByte((int)cmd);
        buf.writeByte(0);
        FastdfsUtils.writeFixLength(buf, this.fileId.group(), 16);
        ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)this.fileId.path());
        return Collections.singletonList(buf);
    }

    protected abstract byte cmd();
}

