/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsUtils;
import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.FileMetadata;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.CharsetUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FileMetadataSetEncoder
implements Requestor.Encoder {
    private final FileId fileId;
    private final FileMetadata metadata;
    private final byte flag;

    public FileMetadataSetEncoder(FileId fileId, FileMetadata metadata, byte flag) {
        this.fileId = Objects.requireNonNull(fileId);
        this.metadata = metadata;
        this.flag = flag;
    }

    @Override
    public List<Object> encode(ByteBufAllocator alloc) {
        byte[] pathBytes = this.fileId.pathBytes();
        byte[] metadatas = this.metadata.toBytes(CharsetUtil.UTF_8);
        int length = 33 + pathBytes.length + metadatas.length;
        int cmd = 13;
        ByteBuf buf = alloc.buffer(length + 10);
        buf.writeLong((long)length);
        buf.writeByte(cmd);
        buf.writeByte(0);
        buf.writeLong((long)pathBytes.length);
        buf.writeLong((long)metadatas.length);
        buf.writeByte((int)this.flag);
        FastdfsUtils.writeFixLength(buf, this.fileId.group(), 16);
        buf.writeBytes(pathBytes);
        buf.writeBytes(metadatas);
        return Collections.singletonList(buf);
    }
}

