/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileOperationEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;

public class FileModifyEncoder
extends FileOperationEncoder {
    private final FileId fileId;
    private final long offset;

    public FileModifyEncoder(FileId fileId, File file, long offset) {
        super(file);
        this.fileId = fileId;
        this.offset = offset;
    }

    public FileModifyEncoder(FileId fileId, Object content, long size, long offset) {
        super(content, size);
        this.fileId = fileId;
        this.offset = offset;
    }

    @Override
    protected byte cmd() {
        return 34;
    }

    @Override
    protected ByteBuf metadata(ByteBufAllocator alloc) {
        byte[] pathBytes = this.fileId.pathBytes();
        int metaLen = 24 + pathBytes.length;
        ByteBuf buf = alloc.buffer(metaLen);
        buf.writeLong((long)pathBytes.length);
        buf.writeLong(this.offset);
        buf.writeLong(this.size());
        buf.writeBytes(pathBytes);
        return buf;
    }
}

