/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.handler.stream.ChunkedStream;
import java.io.File;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.List;

abstract class FileOperationEncoder
implements Requestor.Encoder {
    private final Object content;
    private final long size;

    FileOperationEncoder(File file) {
        long length = file.length();
        this.content = new DefaultFileRegion(file, 0L, length);
        this.size = length;
    }

    FileOperationEncoder(Object content, long size) {
        this.content = FileOperationEncoder.toContent(content);
        this.size = size;
    }

    private static Object toContent(Object content) {
        if (content instanceof File) {
            File file = (File)content;
            return new DefaultFileRegion(file, 0L, file.length());
        }
        if (content instanceof InputStream) {
            return new ChunkedStream((InputStream)content);
        }
        if (content instanceof ReadableByteChannel) {
            return new ChunkedNioStream((ReadableByteChannel)content);
        }
        if (content instanceof byte[]) {
            return Unpooled.wrappedBuffer((byte[])((byte[])content));
        }
        throw new IllegalArgumentException("unknown content type : " + content.getClass().getName());
    }

    @Override
    public List<Object> encode(ByteBufAllocator alloc) {
        ByteBuf meta = this.metadata(alloc);
        ByteBuf head = alloc.buffer(10);
        head.writeLong((long)meta.readableBytes() + this.size);
        head.writeByte((int)this.cmd());
        head.writeByte(0);
        CompositeByteBuf cbb = alloc.compositeBuffer();
        cbb.addComponents(new ByteBuf[]{head, meta});
        cbb.writerIndex(head.readableBytes() + meta.readableBytes());
        LinkedList<Object> requests = new LinkedList<Object>();
        requests.add(cbb);
        requests.add(this.content);
        return requests;
    }

    protected Object content() {
        return this.content;
    }

    protected long size() {
        return this.size;
    }

    protected abstract byte cmd();

    protected abstract ByteBuf metadata(ByteBufAllocator var1);
}

