/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FileId;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Requestor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.CharsetUtil;
import java.util.Collections;
import java.util.List;

public class FileTruncateEncoder
implements Requestor.Encoder {
    private final FileId fileId;
    private final long truncatedSize;

    public FileTruncateEncoder(FileId fileId, long truncatedSize) {
        this.fileId = fileId;
        this.truncatedSize = truncatedSize;
    }

    @Override
    public List<Object> encode(ByteBufAllocator alloc) {
        byte[] pathBytes = this.fileId.path().getBytes(CharsetUtil.UTF_8);
        int length = 16 + pathBytes.length;
        int cmd = 36;
        ByteBuf buf = alloc.buffer(length + 10);
        buf.writeLong((long)length);
        buf.writeByte(cmd);
        buf.writeByte(0);
        buf.writeLong((long)pathBytes.length);
        buf.writeLong(this.truncatedSize);
        buf.writeBytes(pathBytes);
        return Collections.singletonList(buf);
    }
}

