/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsUtils;
import com.jeesuite.filesystem.sdk.fdfs.codec.FileOperationEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;

public class FileUploadEncoder
extends FileOperationEncoder {
    private final String ext;
    private final byte pathIdx;

    public FileUploadEncoder(File file, byte pathIdx) {
        super(file);
        this.ext = FastdfsUtils.getFileExt(file.getName(), "tmp");
        this.pathIdx = pathIdx;
    }

    public FileUploadEncoder(Object content, String filename, long size, byte pathIdx) {
        super(content, size);
        this.ext = FastdfsUtils.getFileExt(filename, "tmp");
        this.pathIdx = pathIdx;
    }

    @Override
    protected ByteBuf metadata(ByteBufAllocator alloc) {
        int metaLen = 15;
        ByteBuf buf = alloc.buffer(metaLen);
        buf.writeByte((int)this.pathIdx);
        buf.writeLong(this.size());
        FastdfsUtils.writeFixLength(buf, this.ext, 6);
        return buf;
    }

    @Override
    protected byte cmd() {
        return 11;
    }
}

