/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.codec;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsException;
import com.jeesuite.filesystem.sdk.fdfs.FastdfsUtils;
import com.jeesuite.filesystem.sdk.fdfs.StorageServer;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Replier;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public enum StorageServerListDecoder implements Replier.Decoder<List<StorageServer>>
{
    INSTANCE;


    @Override
    public List<StorageServer> decode(ByteBuf in) {
        int size = in.readableBytes();
        if (size < 39) {
            throw new FastdfsException("body length : " + size + " is less than required length " + 39);
        }
        if ((size - 39) % 15 != 0) {
            throw new FastdfsException("body length : " + size + " is invalidate. ");
        }
        int count = (size - 39) / 15 + 1;
        ArrayList<StorageServer> results = new ArrayList<StorageServer>(count);
        String group = FastdfsUtils.readString(in, 16);
        String mainHost = FastdfsUtils.readString(in, 15);
        int port = (int)in.readLong();
        results.add(new StorageServer(group, mainHost, port));
        for (int i = 1; i < count; ++i) {
            String host = FastdfsUtils.readString(in, 15);
            results.add(new StorageServer(group, host, port));
        }
        return results;
    }
}

