/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.exchange;

import com.jeesuite.filesystem.sdk.fdfs.exchange.Replier;
import com.jeesuite.filesystem.sdk.fdfs.exchange.ReplierSupport;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;

public class ReplierDecoder<T>
extends ReplierSupport<T> {
    private Replier.Decoder<T> decoder;

    public ReplierDecoder(Replier.Decoder<T> decoder) {
        this.decoder = decoder;
    }

    @Override
    protected long expectLength() {
        return this.decoder.expectLength();
    }

    @Override
    protected void readContent(ByteBuf in, CompletableFuture<T> promise) {
        if ((long)in.readableBytes() < this.length) {
            return;
        }
        ByteBuf buf = in.readSlice((int)this.length);
        T result = this.decoder.decode(buf);
        promise.complete(result);
        this.atHead = true;
    }

    public String toString() {
        return "ReplierDecoder{decoder=" + this.decoder + '}';
    }
}

