/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.exchange;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsException;
import com.jeesuite.filesystem.sdk.fdfs.exchange.Replier;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;

public abstract class ReplierSupport<T>
implements Replier<T> {
    protected boolean atHead = true;
    protected long length;

    @Override
    public void reply(ByteBuf in, CompletableFuture<T> promise) {
        if (this.atHead) {
            this.readHead(in);
        }
        this.readContent(in, promise);
    }

    private void readHead(ByteBuf in) {
        if (in.readableBytes() < 10) {
            return;
        }
        this.length = in.readLong();
        byte cmd = in.readByte();
        byte errno = in.readByte();
        if (errno != 0) {
            throw new FastdfsException("Fastdfs responsed with an error, errno is " + errno);
        }
        if (cmd != 100) {
            throw new FastdfsException("Expect response command code error : " + cmd);
        }
        long expectLength = this.expectLength();
        if (expectLength >= 0L && this.length != expectLength) {
            throw new FastdfsException("Expect response length : " + expectLength + " , but reply length : " + this.length);
        }
        this.atHead = false;
    }

    protected long expectLength() {
        return -1L;
    }

    protected abstract void readContent(ByteBuf var1, CompletableFuture<T> var2);
}

