/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.sdk.fdfs.exchange;

import com.jeesuite.filesystem.sdk.fdfs.FastdfsException;
import com.jeesuite.filesystem.sdk.fdfs.exchange.ReplierSupport;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.GatheringByteChannel;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class StreamReplier
extends ReplierSupport<Void> {
    private final Sink sink;
    private long readed = 0L;

    public static StreamReplier stream(Object out) {
        Objects.requireNonNull(out);
        return new StreamReplier(StreamReplier.newSink(out));
    }

    private static Sink newSink(Object out) {
        if (out instanceof OutputStream) {
            return new OioSink((OutputStream)out);
        }
        if (out instanceof GatheringByteChannel) {
            return new NioSink((GatheringByteChannel)out);
        }
        throw new FastdfsException("unknown sink output type " + out.getClass().getName());
    }

    private StreamReplier(Sink sink) {
        this.sink = sink;
    }

    @Override
    protected void readContent(ByteBuf in, CompletableFuture<Void> promise) {
        try {
            int before = in.readableBytes();
            this.sink.write(in);
            int after = in.readableBytes();
            this.readed += (long)(before - after);
            if (this.readed >= this.length) {
                promise.complete(null);
            }
        }
        catch (IOException e) {
            throw new FastdfsException("write response to output error.", e);
        }
    }

    public String toString() {
        return "StreamReplier{sink=" + this.sink + ", readed=" + this.readed + '}';
    }

    private static class NioSink
    implements Sink {
        private GatheringByteChannel out;

        NioSink(GatheringByteChannel out) {
            this.out = out;
        }

        @Override
        public void write(ByteBuf buf) throws IOException {
            buf.readBytes(this.out, buf.readableBytes());
        }
    }

    private static class OioSink
    implements Sink {
        private OutputStream out;

        OioSink(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(ByteBuf buf) throws IOException {
            buf.readBytes(this.out, buf.readableBytes());
        }
    }

    private static interface Sink {
        public void write(ByteBuf var1) throws IOException;
    }
}

