/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.filesystem.spring;

import com.jeesuite.filesystem.FSProvider;
import com.jeesuite.filesystem.UploadObject;
import com.jeesuite.filesystem.UploadTokenParam;
import com.jeesuite.filesystem.provider.fdfs.FdfsProvider;
import com.jeesuite.filesystem.provider.qiniu.QiniuProvider;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class FSProviderSpringFacade
implements InitializingBean,
DisposableBean {
    private FSProvider fsProvider;
    String endpoint;
    String provider;
    String groupName;
    String accessKey;
    String secretKey;
    String urlprefix;
    String servers;
    long connectTimeout = 3000L;
    int maxThreads = 50;
    boolean privated;

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setUrlprefix(String urlprefix) {
        this.urlprefix = urlprefix;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public void setPrivated(boolean privated) {
        this.privated = privated;
    }

    public void destroy() throws Exception {
        this.fsProvider.close();
    }

    public void afterPropertiesSet() throws Exception {
        if ("qiniu".equals(this.provider)) {
            Validate.notBlank((CharSequence)this.accessKey, (String)"[accessKey] not defined", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.secretKey, (String)"[secretKey] not defined", (Object[])new Object[0]);
            this.fsProvider = new QiniuProvider(this.urlprefix, this.groupName, this.accessKey, this.secretKey, this.privated);
        } else if ("fastDFS".equals(this.provider)) {
            Validate.isTrue((this.servers != null && this.servers.matches("^.+[:]\\d{1,5}\\s*$") ? 1 : 0) != 0, (String)"[servers] is not valid", (Object[])new Object[0]);
            String[] serversArray = this.servers.split(",|;");
            this.fsProvider = new FdfsProvider(this.urlprefix, this.groupName, serversArray, this.connectTimeout, this.maxThreads);
        } else if ("aliyun".equals(this.provider)) {
            Validate.notBlank((CharSequence)this.endpoint, (String)"[endpoint] not defined", (Object[])new Object[0]);
        } else {
            throw new RuntimeException("Provider[" + this.provider + "] not support");
        }
    }

    public String upload(String fileName, File file) {
        return this.fsProvider.upload(new UploadObject(fileName, file));
    }

    public String upload(String fileName, InputStream in, String mimeType) {
        return this.fsProvider.upload(new UploadObject(fileName, in, mimeType));
    }

    public boolean delete(String fileName) {
        return this.fsProvider.delete(fileName);
    }

    public Map<String, Object> createUploadToken(UploadTokenParam param) {
        return this.fsProvider.createUploadToken(param);
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

