/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.spring;

import com.jeesuite.spring.SpringInstanceProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ApplicationContext;

public class InstanceFactory {
    private static SpringInstanceProvider instanceProvider;
    private static Long timeStarting;
    private static AtomicBoolean initialized;
    private static AtomicBoolean loadFinished;

    public static void setInstanceProvider(SpringInstanceProvider provider) {
        if (instanceProvider != null) {
            return;
        }
        instanceProvider = provider;
        initialized.set(true);
    }

    public static void loadFinished(SpringInstanceProvider provider) {
        InstanceFactory.setInstanceProvider(provider);
        loadFinished.set(true);
    }

    public static boolean isLoadfinished() {
        return loadFinished.get();
    }

    public static <T> T getInstance(Class<T> beanClass) {
        return InstanceFactory.getInstanceProvider().getInstance(beanClass);
    }

    public static <T> T getInstance(Class<T> beanClass, String beanName) {
        return InstanceFactory.getInstanceProvider().getInstance(beanClass, beanName);
    }

    public static <T> T getInstance(String beanName) {
        return InstanceFactory.getInstanceProvider().getInstance(beanName);
    }

    public static SpringInstanceProvider getInstanceProvider() {
        return instanceProvider;
    }

    public static ApplicationContext getContext() {
        return InstanceFactory.getInstanceProvider().getApplicationContext();
    }

    public static synchronized void waitUtilInitialized() {
        if (initialized.get()) {
            return;
        }
        while (!initialized.get()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long waiting = System.currentTimeMillis() - timeStarting;
            if (waiting > 60000L) {
                throw new RuntimeException("Spring Initialize failture");
            }
            System.out.println("Spring Initializing >>>>>" + waiting + " s");
        }
    }

    public static boolean isInitialized() {
        return initialized.get();
    }

    static {
        timeStarting = System.currentTimeMillis();
        initialized = new AtomicBoolean(false);
        loadFinished = new AtomicBoolean(false);
    }
}

