/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.spring.helper;

import com.jeesuite.spring.InstanceFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class EnvironmentHelper {
    private static Environment environment;

    public static String getProperty(String key) {
        EnvironmentHelper.init();
        return environment == null ? null : environment.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (environment != null || !InstanceFactory.isInitialized()) return;
        Class<EnvironmentHelper> clazz = EnvironmentHelper.class;
        synchronized (EnvironmentHelper.class) {
            environment = InstanceFactory.getInstance(Environment.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean containsProperty(String key) {
        EnvironmentHelper.init();
        return environment == null ? false : environment.containsProperty(key);
    }

    public static Map<String, Object> getAllProperties(String prefix) {
        EnvironmentHelper.init();
        if (environment == null) {
            return null;
        }
        MutablePropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (PropertySource source : propertySources) {
            if (source.getName().startsWith("servlet") || source.getName().startsWith("system") || !(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                Object value;
                boolean match = StringUtils.isEmpty((Object)prefix);
                if (!match) {
                    match = name.startsWith(prefix);
                }
                if (!match || (value = source.getProperty(name)) == null) continue;
                properties.put(name, value);
            }
        }
        return Collections.unmodifiableMap(properties);
    }
}

