/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.spring.helper;

import java.lang.reflect.Field;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ClassUtils;

public class SpringAopHelper {
    public static Object getTarget(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            Object object = SpringAopHelper.getJdkDynamicProxyTargetObject(proxy);
            return SpringAopHelper.getTarget(object);
        }
        Object object = SpringAopHelper.getCglibProxyTargetObject(proxy);
        return SpringAopHelper.getTarget(object);
    }

    public Class<?> getTargetClass(Object object) {
        return ClassUtils.getUserClass((Object)object);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }
}

