/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.LocaleToCharsetMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class LocaleNegotiator {
    private ResourceBundle chosenBundle;
    private Locale chosenLocale;
    private String chosenCharset;

    public LocaleNegotiator(String bundleName, String languages, String charsets) {
        Locale defaultLocale = new Locale("en", "US");
        String defaultCharset = "ISO-8859-1";
        ResourceBundle defaultBundle = null;
        try {
            defaultBundle = ResourceBundle.getBundle(bundleName, defaultLocale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (languages == null) {
            this.chosenLocale = defaultLocale;
            this.chosenCharset = defaultCharset;
            this.chosenBundle = defaultBundle;
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(languages, ",");
        while (tokenizer.hasMoreTokens()) {
            String charset;
            String lang = tokenizer.nextToken();
            Locale loc = this.getLocaleForLanguage(lang);
            ResourceBundle bundle = this.getBundleNoFallback(bundleName, loc);
            if (bundle == null || (charset = this.getCharsetForLocale(loc, charsets)) == null) continue;
            this.chosenLocale = loc;
            this.chosenBundle = bundle;
            this.chosenCharset = charset;
            return;
        }
        this.chosenLocale = defaultLocale;
        this.chosenCharset = defaultCharset;
        this.chosenBundle = defaultBundle;
    }

    public ResourceBundle getBundle() {
        return this.chosenBundle;
    }

    public Locale getLocale() {
        return this.chosenLocale;
    }

    public String getCharset() {
        return this.chosenCharset;
    }

    private Locale getLocaleForLanguage(String lang) {
        int dash;
        int semi = lang.indexOf(59);
        if (semi != -1) {
            lang = lang.substring(0, semi);
        }
        Locale loc = (dash = (lang = lang.trim()).indexOf(45)) == -1 ? new Locale(lang, "") : new Locale(lang.substring(0, dash), lang.substring(dash + 1));
        return loc;
    }

    private ResourceBundle getBundleNoFallback(String bundleName, Locale loc) {
        ResourceBundle fallback = null;
        try {
            fallback = ResourceBundle.getBundle(bundleName, new Locale("bogus", ""));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, loc);
            if (bundle != fallback) {
                return bundle;
            }
            if (bundle == fallback && loc.getLanguage().equals(Locale.getDefault().getLanguage())) {
                return bundle;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    protected String getCharsetForLocale(Locale loc, String charsets) {
        return LocaleToCharsetMap.getCharset(loc);
    }
}

