/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.MethodInfo;
import com.jfinal.template.expr.ast.MethodKit;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.lang.reflect.InvocationTargetException;

public class Method
extends Expr {
    private Expr expr;
    private String methodName;
    private ExprList exprList;
    private boolean optionalChain;

    public Method(Expr expr, String methodName, ExprList exprList, boolean optionalChain, Location location) {
        if (exprList == null || exprList.length() == 0) {
            throw new ParseException("The parameter of method can not be blank", location);
        }
        this.init(expr, methodName, exprList, optionalChain, location);
    }

    public Method(Expr expr, String methodName, boolean optionalChain, Location location) {
        this.init(expr, methodName, ExprList.NULL_EXPR_LIST, optionalChain, location);
    }

    private void init(Expr expr, String methodName, ExprList exprList, boolean optionalChain, Location location) {
        if (expr == null) {
            throw new ParseException("The target for method invoking can not be blank", location);
        }
        if (MethodKit.isForbiddenMethod(methodName)) {
            throw new ParseException("Forbidden method: " + methodName, location);
        }
        this.expr = expr;
        this.methodName = methodName;
        this.exprList = exprList;
        this.optionalChain = optionalChain;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object target = this.expr.eval(scope);
        if (target == null) {
            if (this.optionalChain) {
                return null;
            }
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException("The target for method invoking can not be null, method name: " + this.methodName, this.location);
        }
        Object[] argValues = this.exprList.evalExprList(scope);
        try {
            MethodInfo methodInfo = MethodKit.getMethod(target.getClass(), this.methodName, argValues);
            if (methodInfo.notNull()) {
                return methodInfo.invoke(target, argValues);
            }
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException(Method.buildMethodNotFoundSignature("public method not found: " + target.getClass().getName() + ".", this.methodName, argValues), this.location);
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            throw new TemplateException(t.getMessage(), this.location, t);
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }

    static String buildMethodNotFoundSignature(String preMsg, String methodName, Object[] argValues) {
        StringBuilder ret = new StringBuilder().append(preMsg).append(methodName).append("(");
        if (argValues != null) {
            for (int i = 0; i < argValues.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(argValues[i] != null ? argValues[i].getClass().getName() : "null");
            }
        }
        return ret.append(")").toString();
    }
}

