/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor;

import com.google.common.collect.Maps;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.ext.render.exception.ExceptionRender;
import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;
import java.util.Map;

public class ExceptionInterceptor
implements Interceptor {
    private ExceptionRender defaultRender;
    private Map<Class<? extends Exception>, ExceptionRender> exceptionMapping = Maps.newHashMap();

    public ExceptionInterceptor setDefault(String defaultView) {
        this.defaultRender = new DefaultExceptionRender(defaultView);
        return this;
    }

    public ExceptionInterceptor setDefault(ExceptionRender defaultRender) {
        this.defaultRender = defaultRender;
        return this;
    }

    public ExceptionInterceptor addMapping(Class<? extends Exception> cause, String view) {
        this.exceptionMapping.put(cause, new DefaultExceptionRender(view));
        return this;
    }

    public ExceptionInterceptor addMapping(Class<? extends Exception> cause, ExceptionRender view) {
        this.exceptionMapping.put(cause, view);
        return this;
    }

    public void intercept(ActionInvocation ai) {
        block3: {
            try {
                ai.invoke();
            }
            catch (Exception e) {
                ExceptionRender exceptionRender = this.matchRender(e);
                if (exceptionRender == null) {
                    exceptionRender = this.defaultRender;
                }
                if (exceptionRender == null) break block3;
                ai.getController().render((Render)exceptionRender.setException(e));
            }
        }
    }

    private ExceptionRender matchRender(Exception e) {
        Class<?> clazz = e.getClass();
        Class<?> superclass = clazz.getSuperclass();
        ExceptionRender exceptionRender = null;
        while (superclass != null) {
            superclass = clazz.getSuperclass();
            exceptionRender = this.exceptionMapping.get(clazz);
            if (exceptionRender != null) break;
            clazz = superclass;
        }
        return exceptionRender;
    }

    private class DefaultExceptionRender
    extends ExceptionRender {
        public DefaultExceptionRender(String view) {
            this.view = view;
        }

        public void render() {
            RenderFactory.me().getRender(this.view).setContext(this.request, this.response).render();
        }
    }
}

