/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor.pageinfo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.pageinfo.Condition;
import com.jfinal.ext.interceptor.pageinfo.Filter;
import com.jfinal.ext.interceptor.pageinfo.PageInfo;
import com.jfinal.ext.interceptor.pageinfo.PageInfoInterceptor;
import com.jfinal.ext.interceptor.pageinfo.RelationInfo;
import com.jfinal.ext.kit.ModelExt;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Logger;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PageInfoKit {
    protected static final Logger LOG = Logger.getLogger(PageInfoKit.class);
    private static final String OPERATOR_SUFFIX = "_op";
    private static final String FILTER_PREFIX = "f_";

    public static Page populate(PageInfo pageInfo, PageInfoInterceptor pageInfoInterceptor) {
        Class<Model<?>> model = pageInfoInterceptor.model();
        Table tableinfo = TableMapping.me().getTable(model);
        Map columnTypeMap = (Map)Reflect.on(tableinfo).get("columnTypeMap");
        String select = "select ";
        if (StrKit.isBlank((String)pageInfoInterceptor.columns())) {
            Set set = columnTypeMap.keySet();
            for (String item : set) {
                select = select + item + ",";
            }
            if (!pageInfoInterceptor.relations().isEmpty()) {
                for (RelationInfo relation : pageInfoInterceptor.relations()) {
                    Class<Model<?>> modelClass = relation.getModel();
                    Table relationTableinfo = TableMapping.me().getTable(modelClass);
                    Map relationColumnTypeMap = (Map)Reflect.on(relationTableinfo).get("columnTypeMap");
                    set = relationColumnTypeMap.keySet();
                    for (String item : set) {
                        if (pageInfoInterceptor.useColumnLabel() || PageInfoKit.columnConflict(item, model, modelClass, pageInfoInterceptor.relations())) {
                            if (!select.contains(StrKit.firstCharToLowerCase((String)model.getSimpleName()) + "." + item)) {
                                if (select.contains("," + item + ",")) {
                                    select = select.replace("," + item + ",", "," + StrKit.firstCharToLowerCase((String)model.getSimpleName()) + "." + item + ",");
                                }
                                if (select.contains(" " + item + ",")) {
                                    select = select.replace(" " + item + ",", " " + StrKit.firstCharToLowerCase((String)model.getSimpleName()) + "." + item + ",");
                                }
                            }
                            select = select + StrKit.firstCharToLowerCase((String)modelClass.getSimpleName()) + "." + item + " " + StrKit.firstCharToLowerCase((String)modelClass.getSimpleName()) + "_" + item + ",";
                            continue;
                        }
                        select = select + item + ",";
                    }
                }
            }
            select = select.substring(0, select.length() - 1);
        } else {
            select = select + pageInfoInterceptor.columns();
        }
        ArrayList paras = Lists.newArrayList();
        String sqlExceptSelect = "from " + tableinfo.getName();
        for (RelationInfo relationInfo : pageInfoInterceptor.relations()) {
            String tableName = TableMapping.me().getTable(relationInfo.getModel()).getName();
            String val = relationInfo.getCondition();
            sqlExceptSelect = sqlExceptSelect + " left join " + tableName + " on ( " + val + ") ";
        }
        sqlExceptSelect = sqlExceptSelect + " where 1=1 ";
        List<Filter> filters = pageInfo.getFilters();
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = filters.get(i);
            List<Condition> conditions = filter.getConditions();
            sqlExceptSelect = sqlExceptSelect + filter.getRelation();
            sqlExceptSelect = sqlExceptSelect + " ( 1=1 ";
            for (int j = 0; j < conditions.size(); ++j) {
                Condition condition = conditions.get(j);
                String fieldName = condition.getFieldName();
                Object value = condition.getValue();
                if (value == null) continue;
                if (condition.getOperater().equals("LIKE")) {
                    paras.add("%" + value + "%");
                } else if (!condition.getOperater().equals("NULL") && !condition.getOperater().equals("NOTNULL")) {
                    paras.add(value);
                }
                sqlExceptSelect = condition.getOperater().equals("NULL") ? sqlExceptSelect + condition.getRelation() + " " + fieldName + " IS NULL " : (condition.getOperater().equals("NOTNULL") ? sqlExceptSelect + condition.getRelation() + " " + fieldName + " IS NOT NULL " : sqlExceptSelect + condition.getRelation() + " " + fieldName + " " + condition.getOperater() + " ? ");
            }
            sqlExceptSelect = sqlExceptSelect + " ) ";
        }
        String sorterField = pageInfo.getSorterField();
        if (sorterField != null) {
            sqlExceptSelect = sqlExceptSelect + " order by " + sorterField + " " + pageInfo.getSorterDirection();
        }
        if (pageInfoInterceptor.relations().isEmpty()) {
            Model modelInstance = (Model)Reflect.on(model).create().get();
            return modelInstance.paginate(pageInfo.getPageNumber(), pageInfo.getPageSize(), select, sqlExceptSelect, paras.toArray(new Object[0]));
        }
        return Db.paginate((int)pageInfo.getPageNumber(), (int)pageInfo.getPageSize(), (String)select, (String)sqlExceptSelect, (Object[])paras.toArray(new Object[0]));
    }

    private static boolean columnConflict(String item, Class<? extends Model<?>> mainModel, Class<? extends Model<?>> currentModel, List<RelationInfo> relations) {
        if (TableMapping.me().getTable(mainModel).hasColumnLabel(item)) {
            return true;
        }
        for (RelationInfo relationInfo : relations) {
            if (currentModel == relationInfo.getModel() || !TableMapping.me().getTable(relationInfo.getModel()).hasColumnLabel(item)) continue;
            return true;
        }
        return false;
    }

    public static PageInfo injectPageInfo(Class<? extends Model<?>> modelClass, Controller controller, List<RelationInfo> relations) {
        int index;
        HashMap modelAttrs = Maps.newHashMap();
        ArrayList modelNames = Lists.newArrayList();
        HashMap models = Maps.newHashMap();
        PageInfo pageInfo = new PageInfo();
        String modelName = StrKit.firstCharToLowerCase((String)modelClass.getSimpleName());
        pageInfo.setPageNumber(controller.getParaToInt("pageNumber", Integer.valueOf(1)));
        pageInfo.setPageSize(controller.getParaToInt("pageSize", Integer.valueOf(10)));
        modelNames.add(modelName);
        modelAttrs.put(modelName, new Record());
        for (RelationInfo relationInfo : relations) {
            String tableName = TableMapping.me().getTable(relationInfo.getModel()).getName();
            modelNames.add(tableName);
            modelAttrs.put(StrKit.firstCharToLowerCase((String)relationInfo.getModel().getSimpleName()), new Record());
        }
        Map parasMap = controller.getRequest().getParameterMap();
        for (Map.Entry e : parasMap.entrySet()) {
            String paraKey = (String)e.getKey();
            for (String string : modelNames) {
                if (!paraKey.startsWith(string + ".")) continue;
                String[] paraValue = (String[])e.getValue();
                String value = paraValue[0] != null ? paraValue[0] + "" : null;
                models.put(paraKey, value);
            }
        }
        LinkedHashMap filter = Maps.newLinkedHashMap();
        Set entries = models.entrySet();
        for (Map.Entry entry : entries) {
            String string = (String)entry.getKey();
            for (String item : modelNames) {
                if (!string.startsWith(item + "." + FILTER_PREFIX)) continue;
                index = string.indexOf(FILTER_PREFIX);
                String value = (String)entry.getValue();
                if (StrKit.isBlank((String)value)) continue;
                filter.put(string.substring(0, index) + string.substring(index + FILTER_PREFIX.length()), value);
            }
        }
        ArrayList filters = Lists.newArrayList();
        for (Map.Entry entry : filter.entrySet()) {
            String key = (String)entry.getKey();
            if (key.endsWith(OPERATOR_SUFFIX)) continue;
            String operater = (String)filter.get(key + OPERATOR_SUFFIX);
            if (StrKit.isBlank((String)operater)) {
                operater = "=";
            }
            index = key.indexOf(".");
            ((Record)modelAttrs.get(key.substring(0, index))).set(FILTER_PREFIX + key.substring(index + 1, key.length()), entry.getValue());
            Filter newFilter = new Filter();
            newFilter.addConditions(key, entry.getValue(), operater);
            filters.add(newFilter);
        }
        PageInfoKit.pseudoDelete(modelClass, modelName, filters);
        for (RelationInfo relationInfo : relations) {
            PageInfoKit.pseudoDelete(relationInfo.getModel(), modelName, filters);
        }
        pageInfo.setFilters(filters);
        PageInfoKit.addSorter(controller, pageInfo);
        for (Map.Entry entry : modelAttrs.entrySet()) {
            controller.setAttr((String)entry.getKey(), entry.getValue());
        }
        return pageInfo;
    }

    private static void addSorter(Controller controller, PageInfo pageInfo) {
        String sorterField = controller.getRequest().getParameter("sorterField");
        if (StrKit.notBlank((String)sorterField)) {
            String sorterDirection = controller.getRequest().getParameter("sorterDirection");
            if (StrKit.isBlank((String)sorterDirection)) {
                sorterDirection = "desc";
            }
            pageInfo.setSorterField(sorterField);
            pageInfo.setSorterDirection(sorterDirection);
        }
    }

    private static void pseudoDelete(Class<? extends Model<?>> modelClass, String modelName, List<Filter> filters) {
        ModelExt modelExt;
        if (ModelExt.class.isAssignableFrom(modelClass) && (modelExt = (ModelExt)((Object)Reflect.on(modelClass).create().get())).pseudoDelete()) {
            Filter deletefilter = new Filter();
            deletefilter.addConditions(modelName + ".deleteflag", 0, "=");
            deletefilter.addConditions(modelName + ".deleteflag", 0, "NULL", "OR");
            filters.add(deletefilter);
        }
    }
}

