/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit.excel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PoiExporter {
    public static final String VERSION_2003 = "2003";
    private static final int HEADER_ROW = 1;
    private static final int MAX_ROWS = 65535;
    private String version;
    private String[] sheetNames = new String[]{"sheet"};
    private int cellWidth = 8000;
    private int headerRow;
    private String[][] headers;
    private String[][] columns;
    private List<?>[] data;

    public PoiExporter(List<?> ... data) {
        this.data = data;
    }

    public static PoiExporter data(List<?> ... data) {
        return new PoiExporter(data);
    }

    public static List<List<?>> dice(List<?> num, int chunkSize) {
        int size = num.size();
        int chunk_num = size / chunkSize + (size % chunkSize == 0 ? 0 : 1);
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < chunk_num; ++i) {
            result.add(Lists.newArrayList(num.subList(i * chunkSize, i == chunk_num - 1 ? size : (i + 1) * chunkSize)));
        }
        return result;
    }

    public Workbook export() {
        int i;
        HSSFWorkbook wb;
        Preconditions.checkNotNull(this.data, (Object)"data can not be null");
        Preconditions.checkNotNull((Object)this.headers, (Object)"headers can not be null");
        Preconditions.checkNotNull((Object)this.columns, (Object)"columns can not be null");
        Preconditions.checkArgument((this.data.length == this.sheetNames.length && this.sheetNames.length == this.headers.length && this.headers.length == this.columns.length ? 1 : 0) != 0, (Object)("data,sheetNames,headers and columns'length should be the same.(data:" + this.data.length + ",sheetNames:" + this.sheetNames.length + ",headers:" + this.headers.length + ",columns:" + this.columns.length + ")"));
        Preconditions.checkArgument((this.cellWidth >= 0 ? 1 : 0) != 0, (Object)"cellWidth can not be less than 0");
        if (VERSION_2003.equals(this.version)) {
            wb = new HSSFWorkbook();
            if (this.data.length > 1) {
                for (i = 0; i < this.data.length; ++i) {
                    List<?> item = this.data[i];
                    Preconditions.checkArgument((item.size() < 65535 ? 1 : 0) != 0, (Object)("Data [" + i + "] is invalid:invalid data size (" + item.size() + ") outside allowable range (0..65535)"));
                }
            } else if (this.data.length == 1 && this.data[0].size() > 65535) {
                this.data = PoiExporter.dice(this.data[0], 65535).toArray(new List[0]);
                String sheetName = this.sheetNames[0];
                this.sheetNames = new String[this.data.length];
                for (int i2 = 0; i2 < this.data.length; ++i2) {
                    this.sheetNames[i2] = sheetName + (i2 == 0 ? "" : Integer.valueOf(i2 + 1));
                }
                String[] header = this.headers[0];
                this.headers = new String[this.data.length][];
                for (int i3 = 0; i3 < this.data.length; ++i3) {
                    this.headers[i3] = header;
                }
                String[] column = this.columns[0];
                this.columns = new String[this.data.length][];
                for (int i4 = 0; i4 < this.data.length; ++i4) {
                    this.columns[i4] = column;
                }
            }
        } else {
            wb = new XSSFWorkbook();
        }
        if (this.data.length == 0) {
            return wb;
        }
        for (i = 0; i < this.data.length; ++i) {
            Row row;
            Sheet sheet = wb.createSheet(this.sheetNames[i]);
            if (this.headers[i].length > 0) {
                row = sheet.createRow(0);
                if (this.headerRow <= 0) {
                    this.headerRow = 1;
                }
                this.headerRow = Math.min(this.headerRow, 65535);
                int lenH = this.headers[i].length;
                for (int h = 0; h < lenH; ++h) {
                    if (this.cellWidth > 0) {
                        sheet.setColumnWidth(h, this.cellWidth);
                    }
                    Cell cell = row.createCell(h);
                    cell.setCellValue(this.headers[i][h]);
                }
            }
            int len = this.data[i].size();
            for (int j = 0; j < len; ++j) {
                row = sheet.createRow(j + this.headerRow);
                Object obj = this.data[i].get(j);
                if (obj == null) continue;
                if (obj instanceof Map) {
                    PoiExporter.processAsMap(this.columns[i], row, obj);
                    continue;
                }
                if (obj instanceof Model) {
                    PoiExporter.processAsModel(this.columns[i], row, obj);
                    continue;
                }
                if (obj instanceof Record) {
                    PoiExporter.processAsRecord(this.columns[i], row, obj);
                    continue;
                }
                throw new RuntimeException("Not support type[" + obj.getClass() + "]");
            }
        }
        return wb;
    }

    private static void processAsMap(String[] columns, Row row, Object obj) {
        Map map = (Map)obj;
        if (columns.length == 0) {
            Set keys = map.keySet();
            int columnIndex = 0;
            for (String key : keys) {
                Cell cell = row.createCell(columnIndex);
                cell.setCellValue(map.get(key) + "");
                ++columnIndex;
            }
        } else {
            int len = columns.length;
            for (int j = 0; j < len; ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue(map.get(columns[j]) == null ? "" : map.get(columns[j]) + "");
            }
        }
    }

    private static void processAsModel(String[] columns, Row row, Object obj) {
        Model model = (Model)obj;
        Set entries = model.getAttrsEntrySet();
        if (columns.length == 0) {
            int columnIndex = 0;
            for (Map.Entry entry : entries) {
                Cell cell = row.createCell(columnIndex);
                cell.setCellValue(entry.getValue() + "");
                ++columnIndex;
            }
        } else {
            int len = columns.length;
            for (int j = 0; j < len; ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue(model.get(columns[j]) == null ? "" : model.get(columns[j]) + "");
            }
        }
    }

    private static void processAsRecord(String[] columns, Row row, Object obj) {
        Record record = (Record)obj;
        Map map = record.getColumns();
        if (columns.length == 0) {
            record.getColumns();
            Set keys = map.keySet();
            int columnIndex = 0;
            for (String key : keys) {
                Cell cell = row.createCell(columnIndex);
                cell.setCellValue(record.get(key) + "");
                ++columnIndex;
            }
        } else {
            int len = columns.length;
            for (int j = 0; j < len; ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue(map.get(columns[j]) == null ? "" : map.get(columns[j]) + "");
            }
        }
    }

    public PoiExporter version(String version) {
        this.version = version;
        return this;
    }

    public PoiExporter sheetName(String sheetName) {
        this.sheetNames = new String[]{sheetName};
        return this;
    }

    public PoiExporter sheetNames(String ... sheetName) {
        this.sheetNames = sheetName;
        return this;
    }

    public PoiExporter cellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
        return this;
    }

    public PoiExporter headerRow(int headerRow) {
        this.headerRow = headerRow;
        return this;
    }

    public PoiExporter header(String ... header) {
        this.headers = new String[][]{header};
        return this;
    }

    public PoiExporter headers(String[] ... headers) {
        this.headers = headers;
        return this;
    }

    public PoiExporter column(String ... column) {
        this.columns = new String[][]{column};
        return this;
    }

    public PoiExporter columns(String[] ... columns) {
        this.columns = columns;
        return this;
    }
}

