/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.cron;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.ext.kit.ResourceKit;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Logger;
import com.jfinal.plugin.IPlugin;
import it.sauronsoftware.cron4j.Scheduler;
import java.util.Map;
import java.util.Set;

public class Cron4jPlugin
implements IPlugin {
    private static final String JOB = "job";
    private final Logger log = Logger.getLogger(this.getClass());
    private Map<Runnable, String> jobs = Maps.newLinkedHashMap();
    private String config;
    private Scheduler scheduler;
    private Map<String, String> jobProp;

    public Cron4jPlugin add(String jobCronExp, Runnable job) {
        this.jobs.put(job, jobCronExp);
        return this;
    }

    public Cron4jPlugin config(String config) {
        this.config = config;
        return this;
    }

    public boolean start() {
        this.loadJobsFromProperties();
        this.startJobs();
        return true;
    }

    private void startJobs() {
        this.scheduler = new Scheduler();
        Set<Map.Entry<Runnable, String>> set = this.jobs.entrySet();
        for (Map.Entry<Runnable, String> entry : set) {
            this.scheduler.schedule(entry.getValue(), entry.getKey());
            this.log.debug(entry.getValue() + " has been scheduled to run and repeat based on expression: " + entry.getKey());
        }
        this.scheduler.start();
    }

    private void loadJobsFromProperties() {
        if (StrKit.isBlank((String)this.config)) {
            return;
        }
        this.jobProp = ResourceKit.readProperties(this.config);
        Set<Map.Entry<String, String>> entries = this.jobProp.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            if (!key.endsWith(JOB) || !this.isEnableJob(this.enable(key))) continue;
            String jobClassName = this.jobProp.get(key) + "";
            String jobCronExp = this.jobProp.get(this.cronKey(key)) + "";
            Class clazz = (Class)Reflect.on(jobClassName).get();
            try {
                this.jobs.put((Runnable)clazz.newInstance(), jobCronExp);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private String enable(String key) {
        return key.substring(0, key.lastIndexOf(JOB)) + "enable";
    }

    private String cronKey(String key) {
        return key.substring(0, key.lastIndexOf(JOB)) + "cron";
    }

    private boolean isEnableJob(String enableKey) {
        String enable = this.jobProp.get(enableKey);
        return enable == null || !"false".equalsIgnoreCase((enable + "").trim());
    }

    public boolean stop() {
        this.scheduler.stop();
        return true;
    }
}

