/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.quartz;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.ext.kit.ResourceKit;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Logger;
import com.jfinal.plugin.IPlugin;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzPlugin
implements IPlugin {
    public static final String VERSION_1 = "1";
    private static final String JOB = "job";
    private final Logger logger = Logger.getLogger(this.getClass());
    private Map<Job, String> jobs = Maps.newLinkedHashMap();
    private String version;
    private SchedulerFactory sf;
    private Scheduler scheduler;
    private String jobConfig;
    private String confConfig;
    private Map<String, String> jobProp;

    public QuartzPlugin(String jobConfig, String confConfig) {
        this.jobConfig = jobConfig;
        this.confConfig = confConfig;
    }

    public QuartzPlugin(String jobConfig) {
        this.jobConfig = jobConfig;
    }

    public QuartzPlugin() {
    }

    public QuartzPlugin add(String jobCronExp, Job job) {
        this.jobs.put(job, jobCronExp);
        return this;
    }

    public boolean start() {
        this.loadJobsFromProperties();
        this.startJobs();
        return true;
    }

    private void startJobs() {
        try {
            this.sf = StrKit.notBlank((String)this.confConfig) ? new StdSchedulerFactory(this.confConfig) : new StdSchedulerFactory();
            this.scheduler = this.sf.getScheduler();
        }
        catch (SchedulerException e) {
            Throwables.propagate((Throwable)e);
        }
        Set<Map.Entry<Job, String>> set = this.jobs.entrySet();
        for (Map.Entry<Job, String> entry : set) {
            CronTrigger trigger;
            JobDetail jobDetail;
            Job job = entry.getKey();
            String jobClassName = job.getClass().getName();
            String jobCronExp = entry.getValue();
            if (VERSION_1.equals(this.version)) {
                jobDetail = (JobDetail)Reflect.on("org.quartz.JobDetail").create(jobClassName, jobClassName, job.getClass()).get();
                trigger = (CronTrigger)Reflect.on("org.quartz.CronTrigger").create(jobClassName, jobClassName, jobCronExp).get();
            } else {
                jobDetail = (JobDetail)Reflect.on("org.quartz.JobBuilder").call("newJob", job.getClass()).call("withIdentity", jobClassName, jobClassName).call("build").get();
                Object temp = Reflect.on("org.quartz.TriggerBuilder").call("newTrigger").get();
                temp = Reflect.on(temp).call("withIdentity", jobClassName, jobClassName).get();
                temp = Reflect.on(temp).call("withSchedule", Reflect.on("org.quartz.CronScheduleBuilder").call("cronSchedule", jobCronExp).get()).get();
                trigger = (CronTrigger)Reflect.on(temp).call("build").get();
            }
            Date ft = (Date)Reflect.on(this.scheduler).call("scheduleJob", jobDetail, trigger).get();
            this.logger.debug(Reflect.on(jobDetail).call("getKey") + " has been scheduled to run at: " + ft + " " + "and repeat based on expression: " + Reflect.on(trigger).call("getCronExpression"));
        }
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void loadJobsFromProperties() {
        if (StrKit.isBlank((String)this.jobConfig)) {
            return;
        }
        this.jobProp = ResourceKit.readProperties(this.jobConfig);
        Set<Map.Entry<String, String>> entries = this.jobProp.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            if (!key.endsWith(JOB) || !this.isEnableJob(this.enable(key))) continue;
            String jobClassName = this.jobProp.get(key) + "";
            String jobCronExp = this.jobProp.get(this.cronKey(key)) + "";
            Class job = (Class)Reflect.on(jobClassName).get();
            try {
                this.jobs.put((Job)job.newInstance(), jobCronExp);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private String enable(String key) {
        return key.substring(0, key.lastIndexOf(JOB)) + "enable";
    }

    private String cronKey(String key) {
        return key.substring(0, key.lastIndexOf(JOB)) + "cron";
    }

    public QuartzPlugin version(String version) {
        this.version = version;
        return this;
    }

    private boolean isEnableJob(String enableKey) {
        String enable = this.jobProp.get(enableKey);
        return enable == null || !"false".equalsIgnoreCase((enable + "").trim());
    }

    public boolean stop() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            Throwables.propagate((Throwable)e);
        }
        return true;
    }

    public QuartzPlugin confConfig(String confConfig) {
        this.confConfig = confConfig;
        return this;
    }

    public QuartzPlugin jobConfig(String jobConfig) {
        this.jobConfig = jobConfig;
        return this;
    }
}

