/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.redis;

import com.google.common.collect.Lists;
import com.jfinal.ext.kit.SerializableKit;
import com.jfinal.ext.plugin.redis.JedisAction;
import com.jfinal.ext.plugin.redis.JedisAtom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;
import redis.clients.util.SafeEncoder;

public class JedisKit {
    private static Logger LOG = Logger.getLogger(JedisKit.class);
    private static JedisPool pool;

    public static void init(JedisPool pool) {
        JedisKit.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<?> tx(JedisAtom jedisAtom) {
        List result = null;
        Jedis jedis = (Jedis)pool.getResource();
        try {
            Transaction trans = jedis.multi();
            jedisAtom.action(trans);
            result = trans.exec();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != jedis) {
                pool.returnResource((Object)jedis);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T call(JedisAction<T> jedisAction) {
        T result = null;
        Jedis jedis = (Jedis)pool.getResource();
        try {
            result = jedisAction.action(jedis);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != jedis) {
                pool.returnResource((Object)jedis);
            }
        }
        return result;
    }

    public static <T extends Serializable> T get(final String key) {
        return (T)((Serializable)JedisKit.call(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                Object result = null;
                byte[] retVal = jedis.get(SafeEncoder.encode((String)key));
                if (null != retVal) {
                    try {
                        result = SerializableKit.toObject(retVal);
                    }
                    catch (Exception e) {
                        result = SafeEncoder.encode((byte[])retVal);
                    }
                }
                return (Serializable)result;
            }
        }));
    }

    public static boolean set(final String key, final Serializable value) {
        return JedisKit.call(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                String retVal = value instanceof String ? jedis.set(key, (String)((Object)value)) : jedis.set(SafeEncoder.encode((String)key), SerializableKit.toByteArray(value));
                return "OK".equalsIgnoreCase(retVal);
            }
        });
    }

    public static boolean set(final String key, final Serializable value, final int seconds) {
        return JedisKit.call(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                byte[] bytes = value instanceof String ? SafeEncoder.encode((String)((String)((Object)value))) : SerializableKit.toByteArray(value);
                String retVal = jedis.setex(SafeEncoder.encode((String)key), seconds, bytes);
                return "OK".equalsIgnoreCase(retVal);
            }
        });
    }

    public static List<Serializable> mquery(final String ... keys) {
        return JedisKit.call(new JedisAction<List<Serializable>>(){

            @Override
            public List<Serializable> action(Jedis jedis) {
                ArrayList<Serializable> result = new ArrayList<Serializable>(keys.length);
                for (int index = 0; index < keys.length; ++index) {
                    result.add(null);
                }
                byte[][] encodeKeys = new byte[keys.length][];
                for (int i = 0; i < keys.length; ++i) {
                    encodeKeys[i] = SafeEncoder.encode((String)keys[i]);
                }
                List retVals = jedis.mget((byte[][])encodeKeys);
                if (null != retVals) {
                    int index = 0;
                    for (byte[] val : retVals) {
                        if (null != val) {
                            result.set(index, SerializableKit.toObject(val));
                        }
                        ++index;
                    }
                }
                return result;
            }
        });
    }

    public static List<String> mqueryStr(final String ... keys) {
        return JedisKit.call(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.mget(keys);
            }
        });
    }

    public static boolean msaveOrUpdate(final Map<String, Serializable> values) {
        return JedisKit.call(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                byte[][] encodeValues = new byte[values.size() * 2][];
                int index = 0;
                for (Map.Entry entry : values.entrySet()) {
                    encodeValues[index++] = ((String)entry.getKey()).getBytes();
                    encodeValues[index++] = SerializableKit.toByteArray((Serializable)entry.getValue());
                }
                String retVal = jedis.mset((byte[][])encodeValues);
                return "OK".equalsIgnoreCase(retVal);
            }
        });
    }

    public static boolean msaveOrUpdateStr(final Map<String, String> values) {
        return JedisKit.call(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                Iterator iter = values.entrySet().iterator();
                int index = 0;
                String[] encodeValues = new String[values.size() * 2];
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    encodeValues[index++] = (String)entry.getKey();
                    encodeValues[index++] = (String)entry.getValue();
                }
                return "OK".equalsIgnoreCase(jedis.mset(encodeValues));
            }
        });
    }

    public static Set<String> keys(final String pattern) {
        return JedisKit.call(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.keys(pattern);
            }
        });
    }

    public static long del(final String ... keys) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                byte[][] encodeKeys = new byte[keys.length][];
                for (int i = 0; i < keys.length; ++i) {
                    encodeKeys[i] = SafeEncoder.encode((String)keys[i]);
                }
                return jedis.del((byte[][])encodeKeys);
            }
        });
    }

    public static long listAdd(final String key, final Serializable value) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.rpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{SerializableKit.toByteArray(value)});
            }
        });
    }

    public static long listAddFirst(final String key, final Serializable value) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.lpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{SerializableKit.toByteArray(value)});
            }
        });
    }

    public static String type(final String key) {
        return JedisKit.call(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.type(SafeEncoder.encode((String)key));
            }
        });
    }

    public static <T> List<T> queryList(final String key, final int start, final int end) {
        return (List)JedisKit.call(new JedisAction<List<T>>(){

            @Override
            public List<T> action(Jedis jedis) {
                ArrayList result = Lists.newArrayList();
                List retVals = jedis.lrange(SafeEncoder.encode((String)key), (long)start, (long)end);
                if (retVals != null) {
                    for (byte[] val : retVals) {
                        if (null == val) continue;
                        result.add(SerializableKit.toObject(val));
                    }
                }
                return result;
            }
        });
    }

    public static long listSize(final String key) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.llen(SafeEncoder.encode((String)key));
            }
        });
    }

    public static boolean listTrim(final String key, final int start, final int end) {
        return JedisKit.call(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return "OK".equalsIgnoreCase(jedis.ltrim(SafeEncoder.encode((String)key), (long)start, (long)end));
            }
        });
    }

    public static long incrementAndGet(final String key) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.incr(key);
            }
        });
    }

    public static long decrementAndGet(final String key) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.decr(key);
            }
        });
    }

    public static long queryLong(final String key) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return Long.valueOf(jedis.get(key));
            }
        });
    }

    public static boolean hmset(final String key, final Map<String, String> values) {
        return JedisKit.call(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return "OK".equals(jedis.hmset(key, values));
            }
        });
    }

    public static List<String> hvals(final String key) {
        return JedisKit.call(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.hvals(key);
            }
        });
    }

    public static List<String> hmget(final String key, final String ... fields) {
        return JedisKit.call(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.hmget(key, fields);
            }
        });
    }

    public static Double zincrby(final String key, final double score, final String member) {
        return JedisKit.call(new JedisAction<Double>(){

            @Override
            public Double action(Jedis jedis) {
                return jedis.zincrby(key, score, member);
            }
        });
    }

    public static Double zscore(final String key, final String score) {
        return JedisKit.call(new JedisAction<Double>(){

            @Override
            public Double action(Jedis jedis) {
                return jedis.zscore(key, score);
            }
        });
    }

    public static Long zadd(final String key, final double score, final String member) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zadd(key, score, member);
            }
        });
    }

    public static Set<Tuple> zrangeWithScores(final String key, final long start, final long end) {
        return JedisKit.call(new JedisAction<Set<Tuple>>(){

            @Override
            public Set<Tuple> action(Jedis jedis) {
                return jedis.zrangeWithScores(key, start, end);
            }
        });
    }

    public static String watch(final String ... keys) {
        return JedisKit.call(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.watch(keys);
            }
        });
    }

    public static Long lpush(final String key, final Serializable value) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                Long retVal = value instanceof String ? jedis.lpush(key, new String[]{(String)((Object)value)}) : jedis.lpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{SerializableKit.toByteArray(value)});
                return retVal;
            }
        });
    }

    public static <T extends Serializable> T rpop(final String key) {
        return (T)((Serializable)JedisKit.call(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                Object result = null;
                byte[] retVal = jedis.rpop(SafeEncoder.encode((String)key));
                if (null != retVal) {
                    try {
                        result = SerializableKit.toObject(retVal);
                    }
                    catch (Exception e) {
                        result = SafeEncoder.encode((byte[])retVal);
                    }
                }
                return (Serializable)result;
            }
        }));
    }

    public static <T extends Serializable> List<T> lrange(final String key, final long start, final long end) {
        return (List)JedisKit.call(new JedisAction<List<T>>(){

            @Override
            public List<T> action(Jedis jedis) {
                ArrayList list = Lists.newArrayList();
                List results = jedis.lrange(SafeEncoder.encode((String)key), start, end);
                for (byte[] result : results) {
                    try {
                        list.add(SerializableKit.toObject(result));
                    }
                    catch (Exception e) {
                        list.add(SafeEncoder.encode((byte[])result));
                    }
                }
                return list;
            }
        });
    }

    public static <T extends Serializable> T rpoplpush(final String srckey, final String dstkey) {
        return (T)((Serializable)JedisKit.call(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                Object result = null;
                byte[] retVal = jedis.rpoplpush(SafeEncoder.encode((String)srckey), SafeEncoder.encode((String)dstkey));
                if (null != retVal) {
                    try {
                        result = SerializableKit.toObject(retVal);
                    }
                    catch (Exception e) {
                        result = SafeEncoder.encode((byte[])retVal);
                    }
                }
                return (Serializable)result;
            }
        }));
    }

    public static Long lrem(String key, Serializable value) {
        return JedisKit.lrem(key, 1L, value);
    }

    public static Long lrem(final String key, final long count, final Serializable value) {
        return JedisKit.call(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                Long retVal = value instanceof String ? jedis.lrem(key, count, (String)((Object)value)) : jedis.lrem(SafeEncoder.encode((String)key), count, SerializableKit.toByteArray(value));
                return retVal;
            }
        });
    }
}

