/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.redis;

import com.jfinal.ext.kit.SerializableKit;
import com.jfinal.ext.plugin.redis.JedisAtom;
import com.jfinal.ext.plugin.redis.JedisKit;
import com.jfinal.ext.plugin.redis.TopicNest;
import com.jfinal.log.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;

public class TopicPoducer {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private TopicNest topic;
    private TopicNest subscriber;

    public TopicPoducer(String topic) {
        this.topic = new TopicNest("topic:" + topic);
        this.subscriber = new TopicNest(this.topic.cat("subscribers").key());
    }

    public void publish(Serializable message) {
        this.publish(message, 0);
    }

    protected Integer getNextMessageId() {
        String slastMessageId = (String)JedisKit.get(this.topic.key());
        Integer lastMessageId = 0;
        if (slastMessageId != null) {
            lastMessageId = Integer.parseInt(slastMessageId);
        }
        Integer n = lastMessageId;
        Integer n2 = lastMessageId = Integer.valueOf(lastMessageId + 1);
        this.logger.debug(this.topic.key() + " nextMessageId " + lastMessageId);
        return lastMessageId;
    }

    public void clean() {
        Set<Tuple> zrangeWithScores = JedisKit.zrangeWithScores(this.subscriber.key(), 0L, 1L);
        Tuple next = zrangeWithScores.iterator().next();
        Integer lowest = (int)next.getScore();
        String key = this.topic.cat("message").cat(lowest).key();
        this.logger.debug("clean key " + key);
        JedisKit.del(key);
    }

    public void publish(final Serializable message, final int seconds) {
        List<?> exec = null;
        do {
            JedisKit.watch(this.topic.key());
        } while ((exec = JedisKit.tx(new JedisAtom(){

            @Override
            public void action(Transaction trans) {
                Integer nextMessageId = TopicPoducer.this.getNextMessageId();
                String msgKey = TopicPoducer.this.topic.cat("message").cat(nextMessageId).key();
                if (message instanceof String) {
                    trans.set(msgKey, (String)((Object)message));
                } else {
                    trans.set(msgKey.getBytes(), SerializableKit.toByteArray(message));
                }
                TopicPoducer.this.logger.info("produce a message,key[" + msgKey + "],message[" + message + "]");
                trans.set(TopicPoducer.this.topic.key(), nextMessageId.toString());
                if (seconds > 0) {
                    trans.expire(msgKey, seconds);
                }
            }
        })) == null);
    }
}

