/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.shiro;

import com.jfinal.ext.plugin.shiro.AbstractAuthzHandler;
import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.Subject;

class PermissionAuthzHandler
extends AbstractAuthzHandler {
    private final Annotation annotation;

    public PermissionAuthzHandler(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public void assertAuthorized() throws AuthorizationException {
        if (!(this.annotation instanceof RequiresPermissions)) {
            return;
        }
        RequiresPermissions rpAnnotation = (RequiresPermissions)this.annotation;
        String[] perms = rpAnnotation.value();
        Subject subject = this.getSubject();
        if (perms.length == 1) {
            subject.checkPermission(perms[0]);
            return;
        }
        if (Logical.AND.equals((Object)rpAnnotation.logical())) {
            this.getSubject().checkPermissions(perms);
            return;
        }
        if (Logical.OR.equals((Object)rpAnnotation.logical())) {
            boolean hasAtLeastOnePermission = false;
            for (String permission : perms) {
                if (!this.getSubject().isPermitted(permission)) continue;
                hasAtLeastOnePermission = true;
            }
            if (!hasAtLeastOnePermission) {
                this.getSubject().checkPermission(perms[0]);
            }
        }
    }
}

