/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render.csv;

import com.jfinal.ext.render.csv.CsvUtil;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.List;

public class CsvRender
extends Render {
    private List<String> clomuns;
    private List<?> data;
    private String encodeType = "gbk";
    private String fileName = "default.csv";
    private List<String> headers;

    public CsvRender(List<String> headers, List<?> data) {
        this.headers = headers;
        this.data = data;
    }

    public static CsvRender me(List<String> headers, List<?> data) {
        return new CsvRender(headers, data);
    }

    public void render() {
        this.response.reset();
        PrintWriter out = null;
        try {
            this.response.setContentType("application/vnd.ms-excel;charset=" + this.encodeType);
            this.response.setHeader("Content-Disposition", "attachment;  filename=" + URLEncoder.encode(this.fileName, this.encodeType));
            out = this.response.getWriter();
            out.write(CsvUtil.createCSV(this.headers, this.data, this.clomuns));
        }
        catch (Exception e) {
            throw new RenderException((Throwable)e);
        }
        finally {
            if (null != out) {
                out.flush();
                out.close();
            }
        }
    }

    public CsvRender clomuns(List<String> clomuns) {
        this.clomuns = clomuns;
        return this;
    }

    public CsvRender data(List<? extends Object> data) {
        this.data = data;
        return this;
    }

    public CsvRender encodeType(String encodeType) {
        this.encodeType = encodeType;
        return this;
    }

    public CsvRender fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public CsvRender headers(List<String> headers) {
        this.headers = headers;
        return this;
    }
}

