/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.handler;

import com.jfinal.handler.Handler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheControlHeaderHandler
extends Handler {
    private static final int invalidExpirationTime = -1;
    private final int expirationMinutes;
    public final int expires_hour = 60;
    public final int expires_day = 1440;
    public final int expires_nocache = -1;
    public final int expires_week = 10080;

    public CacheControlHeaderHandler(int expirationMinutes) {
        this.expirationMinutes = expirationMinutes;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (!response.isCommitted()) {
            if (this.expirationMinutes == -1) {
                response.setHeader("Cache-Control", "no-cache");
            } else if (this.expirationMinutes > -1) {
                response.setDateHeader("Expires", System.currentTimeMillis() + (long)(this.expirationMinutes * 60 * 1000));
                response.setHeader("Cache-Control", "private");
            }
        }
        this.next.handle(target, request, response, isHandled);
    }
}

