/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor.excel;

import com.google.common.collect.Lists;
import com.jfinal.aop.Invocation;
import com.jfinal.aop.PrototypeInterceptor;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.excel.PostExcelProcessor;
import com.jfinal.ext.interceptor.excel.PostListProcessor;
import com.jfinal.ext.interceptor.excel.PreExcelProcessor;
import com.jfinal.ext.interceptor.excel.PreListProcessor;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.ext.kit.excel.PoiImporter;
import com.jfinal.ext.kit.excel.Rule;
import com.jfinal.ext.kit.excel.filter.RowFilter;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Model;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class ExcelUploadInterceptor<M extends Model<?>>
extends PrototypeInterceptor {
    protected final Log LOG = Log.getLog(((Object)((Object)this)).getClass());
    private Class<?> clazz;
    private Rule rule;

    public abstract Rule configRule();

    public abstract void callback(M var1);

    public ExcelUploadInterceptor() {
        Type genericSuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
        this.clazz = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
    }

    public void doIntercept(Invocation ai) {
        this.rule = this.configRule();
        Controller controller = ai.getController();
        List<Model<?>> list = PoiImporter.processSheet(controller.getFile().getFile(), this.rule, this.clazz);
        this.execPreListProcessor(list);
        for (Model<?> model : list) {
            this.execPreExcelProcessor(model);
            this.callback(model);
            this.execPostExcelProcessor(model);
        }
        this.execPostListProcessor(list);
        ai.invoke();
    }

    private void execPreListProcessor(List<?> list) {
        String preListProcessorClassName = this.rule.getPreListProcessor();
        if (StrKit.notBlank((String)preListProcessorClassName)) {
            PreListProcessor preListProcessor = (PreListProcessor)Reflect.on(preListProcessorClassName).create().get();
            preListProcessor.process(list);
        }
    }

    private void execPostListProcessor(List<?> list) {
        String postListProcessorClassName = this.rule.getPostListProcessor();
        if (StrKit.notBlank((String)postListProcessorClassName)) {
            PostListProcessor postListProcessor = (PostListProcessor)Reflect.on(postListProcessorClassName).create().get();
            postListProcessor.process(list);
        }
    }

    private void execPreExcelProcessor(Object obj) {
        String preExcelProcessorClassName = this.rule.getPreExcelProcessor();
        if (StrKit.notBlank((String)preExcelProcessorClassName)) {
            PreExcelProcessor preExcelProcessor = (PreExcelProcessor)Reflect.on(preExcelProcessorClassName).create().get();
            preExcelProcessor.process(obj);
        }
    }

    private void execPostExcelProcessor(Object obj) {
        String postExcelProcessorClassName = this.rule.getPostExcelProcessor();
        if (StrKit.notBlank((String)postExcelProcessorClassName)) {
            PostExcelProcessor postExcelProcessor = (PostExcelProcessor)Reflect.on(postExcelProcessorClassName).create().get();
            postExcelProcessor.process(obj);
        }
    }

    private List<RowFilter> getRowFilterList(String rowFilter) {
        ArrayList rowFilterList = Lists.newArrayList();
        String[] rowFilters = rowFilter.split(",");
        if (rowFilters == null) {
            return rowFilterList;
        }
        String[] stringArray = rowFilters;
        int n = rowFilters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            rowFilterList.add((RowFilter)Reflect.on(filter).create().get());
            ++n2;
        }
        return rowFilterList;
    }
}

