/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor.syslog;

import com.google.common.collect.Maps;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.syslog.LogConfig;
import com.jfinal.ext.interceptor.syslog.LogProcessor;
import com.jfinal.ext.interceptor.syslog.SysLog;
import com.jfinal.ext.kit.ServletKit;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SysLogInterceptor
implements Interceptor {
    Map<String, LogConfig> acitonLogs = Maps.newHashMap();
    LogProcessor logProcesser = null;

    public SysLogInterceptor setLogProcesser(LogProcessor logProcesser) {
        this.logProcesser = logProcesser;
        return this;
    }

    public SysLogInterceptor addConfig(String actionKey, LogConfig log) {
        this.acitonLogs.put(actionKey, log);
        return this;
    }

    public void intercept(Invocation ai) {
        String actionKey = ai.getActionKey();
        Controller c = ai.getController();
        LogConfig log = this.acitonLogs.get(actionKey);
        if (log != null) {
            this.logFromConfig(c, log);
        }
        ai.invoke();
    }

    private void logFromConfig(Controller c, LogConfig log) {
        SysLog sysLog = new SysLog();
        sysLog.ip = ServletKit.getIp(c.getRequest());
        sysLog.user = this.logProcesser.getUsername(c);
        Map parameterMap = c.getRequest().getParameterMap();
        Set entrySet = parameterMap.entrySet();
        HashMap paraMap = Maps.newHashMap();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String value = ((String[])entry.getValue())[0];
            String result = log.params.get(key);
            if (StrKit.isBlank((String)result)) continue;
            paraMap.put(result, value);
        }
        sysLog.message = this.logProcesser.formatMessage(log.title, paraMap);
        this.logProcesser.process(sysLog);
    }
}

