/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit;

import com.google.common.collect.Lists;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class ClassSearcher {
    protected static final Log LOG = Log.getLog(ClassSearcher.class);
    private String classpath = PathKit.getRootClassPath();
    private String libDir = String.valueOf(PathKit.getWebRootPath()) + File.separator + "WEB-INF" + File.separator + "lib";
    private List<String> scanPackages = Lists.newArrayList();
    private boolean includeAllJarsInLib = false;
    private List<String> includeJars = Lists.newArrayList();
    private Class target;

    private static <T> List<Class<? extends T>> extraction(Class<T> clazz, List<String> classFileList) {
        ArrayList classList = Lists.newArrayList();
        for (String classFile : classFileList) {
            Class classInFile = (Class)Reflect.on(classFile).get();
            if (!clazz.isAssignableFrom(classInFile) || clazz == classInFile) continue;
            classList.add(classInFile);
        }
        return classList;
    }

    public static ClassSearcher of(Class target) {
        return new ClassSearcher(target);
    }

    private static List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList classFiles = Lists.newArrayList();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            LOG.error("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] files = baseDir.list();
            int i = 0;
            while (i < files.length) {
                File file = new File(String.valueOf(baseDirName) + File.separator + files[i]);
                if (file.isDirectory()) {
                    classFiles.addAll(ClassSearcher.findFiles(String.valueOf(baseDirName) + File.separator + files[i], targetFileName));
                } else if (ClassSearcher.wildcardMatch(targetFileName, file.getName())) {
                    String fileName = file.getAbsolutePath();
                    String open = String.valueOf(PathKit.getRootClassPath()) + File.separator;
                    String close = ".class";
                    int start = fileName.indexOf(open);
                    int end = fileName.indexOf(close, start + open.length());
                    String className = fileName.substring(start + open.length(), end).replace(File.separator, ".");
                    classFiles.add(className);
                }
                ++i;
            }
        }
        return classFiles;
    }

    private static boolean wildcardMatch(String pattern, String fileName) {
        int patternLength = pattern.length();
        int strLength = fileName.length();
        int strIndex = 0;
        int patternIndex = 0;
        while (patternIndex < patternLength) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ClassSearcher.wildcardMatch(pattern.substring(patternIndex + 1), fileName.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
            } else if (ch == '?') {
                if (++strIndex > strLength) {
                    return false;
                }
            } else {
                if (strIndex >= strLength || ch != fileName.charAt(strIndex)) {
                    return false;
                }
                ++strIndex;
            }
            ++patternIndex;
        }
        return strIndex == strLength;
    }

    public <T> List<Class<? extends T>> search() {
        List<Object> classFileList = Lists.newArrayList();
        if (this.scanPackages.isEmpty()) {
            classFileList = ClassSearcher.findFiles(this.classpath, "*.class");
        } else {
            for (String scanPackage : this.scanPackages) {
                classFileList = ClassSearcher.findFiles(String.valueOf(this.classpath) + File.separator + scanPackage.replaceAll("\\.", "\\" + File.separator), "*.class");
            }
        }
        classFileList.addAll(this.findjarFiles(this.libDir));
        return ClassSearcher.extraction(this.target, classFileList);
    }

    private List<String> findjarFiles(String baseDirName) {
        ArrayList classFiles = Lists.newArrayList();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            LOG.error("file search error:" + baseDirName + " is not a dir\uff01");
        } else {
            File[] files;
            File[] fileArray = files = baseDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block23: {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        classFiles.addAll(this.findjarFiles(file.getAbsolutePath()));
                    } else if (this.includeAllJarsInLib || this.includeJars.contains(file.getName())) {
                        ZipFile localJarFile = null;
                        try {
                            try {
                                localJarFile = new JarFile(new File(String.valueOf(baseDirName) + File.separator + file.getName()));
                                Enumeration<JarEntry> entries = ((JarFile)localJarFile).entries();
                                while (entries.hasMoreElements()) {
                                    JarEntry jarEntry = entries.nextElement();
                                    String entryName = jarEntry.getName();
                                    if (this.scanPackages.isEmpty()) {
                                        if (jarEntry.isDirectory() || !entryName.endsWith(".class")) continue;
                                        String className = entryName.replaceAll(File.separator, ".").substring(0, entryName.length() - 6);
                                        classFiles.add(className);
                                        continue;
                                    }
                                    for (String scanPackage : this.scanPackages) {
                                        scanPackage = scanPackage.replaceAll("\\.", "\\" + File.separator);
                                        if (jarEntry.isDirectory() || !entryName.endsWith(".class") || !entryName.startsWith(scanPackage)) continue;
                                        String className = entryName.replaceAll(File.separator, ".").substring(0, entryName.length() - 6);
                                        classFiles.add(className);
                                    }
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                try {
                                    if (localJarFile != null) {
                                        localJarFile.close();
                                    }
                                    break block23;
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (localJarFile != null) {
                                    localJarFile.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            if (localJarFile != null) {
                                localJarFile.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
        }
        return classFiles;
    }

    public ClassSearcher(Class target) {
        this.target = target;
    }

    public ClassSearcher injars(List<String> jars) {
        if (jars != null) {
            this.includeJars.addAll(jars);
        }
        return this;
    }

    public ClassSearcher inJars(String ... jars) {
        if (jars != null) {
            String[] stringArray = jars;
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                String jar = stringArray[n2];
                this.includeJars.add(jar);
                ++n2;
            }
        }
        return this;
    }

    public ClassSearcher includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }

    public ClassSearcher classpath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    public ClassSearcher libDir(String libDir) {
        this.libDir = libDir;
        return this;
    }

    public ClassSearcher scanPackages(List<String> scanPaths) {
        if (scanPaths != null) {
            this.scanPackages.addAll(scanPaths);
        }
        return this;
    }
}

