/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit;

import com.google.common.collect.Lists;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.log.Log;
import com.jfinal.plugin.IPlugin;
import java.util.ArrayList;
import java.util.List;

public class JFinalKit {
    protected static final Log LOG = Log.getLog(JFinalKit.class);
    private static List<IPlugin> pluginList;
    private static Constants constants;
    private static Routes routes;
    private static Plugins plugins;
    private static Interceptors interceptors;
    private static Handlers handlers;

    static {
        JFinalKit.init();
    }

    public static void init() {
        Reflect reflect = Reflect.on("com.jfinal.core.Config");
        constants = (Constants)reflect.get("constants");
        routes = (Routes)reflect.get("routes");
        plugins = (Plugins)reflect.get("plugins");
        interceptors = (Interceptors)reflect.get("interceptors");
        handlers = (Handlers)reflect.get("handlers");
        pluginList = plugins.getPluginList();
    }

    public static Constants getConstants() {
        return constants;
    }

    public static Routes getRoutes() {
        return routes;
    }

    public static Plugins getPlugins() {
        return plugins;
    }

    public static Interceptors getInterceptors() {
        return interceptors;
    }

    public static Handlers getHandlers() {
        return handlers;
    }

    public static void stopPlugin(String pluginName) {
        for (IPlugin iPlugin : pluginList) {
            if (!iPlugin.getClass().getSimpleName().equals(pluginName)) continue;
            iPlugin.stop();
        }
    }

    public static List<IPlugin> findPlugin(Class<? extends IPlugin> plugin) {
        return JFinalKit.findPlugin(plugin.getSimpleName());
    }

    public static List<IPlugin> findPlugin(String pluginName) {
        ArrayList plugins = Lists.newArrayList();
        for (IPlugin iPlugin : pluginList) {
            if (!iPlugin.getClass().getSimpleName().equals(pluginName)) continue;
            plugins.add(iPlugin);
        }
        return plugins;
    }

    public static void startPlugin(String pluginName) {
        for (IPlugin iPlugin : pluginList) {
            if (!iPlugin.getClass().getSimpleName().equals(pluginName)) continue;
            iPlugin.start();
        }
    }

    public static void restartPlugin(String pluginName) {
        for (IPlugin iPlugin : pluginList) {
            if (!iPlugin.getClass().getSimpleName().equals(pluginName)) continue;
            iPlugin.stop();
            iPlugin.start();
        }
    }
}

