/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit.excel;

import com.google.common.collect.Lists;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.ext.kit.excel.ExcelException;
import com.jfinal.ext.kit.excel.Rule;
import com.jfinal.ext.kit.excel.convert.CellConvert;
import com.jfinal.ext.kit.excel.filter.RowFilter;
import com.jfinal.ext.kit.excel.validate.CellValidate;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class PoiImporter {
    public static List<List<List<String>>> readExcel(File file, Rule rule) {
        Workbook wb;
        int start = rule.getStart();
        int end = rule.getEnd();
        ArrayList result = Lists.newArrayList();
        try {
            wb = WorkbookFactory.create((File)file);
        }
        catch (Exception e) {
            throw new ExcelException(e);
        }
        int i = 0;
        while (i < wb.getNumberOfSheets()) {
            Sheet sheet = wb.getSheetAt(i);
            ArrayList sheetList = Lists.newArrayList();
            int rows = sheet.getLastRowNum();
            if (start <= sheet.getFirstRowNum()) {
                start = sheet.getFirstRowNum();
            }
            if (end >= rows) {
                end = rows;
            } else if (end <= 0) {
                end = rows + end;
            }
            int rowIndex = start;
            while (rowIndex <= end) {
                Row row = sheet.getRow(rowIndex);
                ArrayList columns = Lists.newArrayList();
                short cellNum = row.getLastCellNum();
                System.out.println(row.getLastCellNum());
                System.out.println(row.getPhysicalNumberOfCells());
                int cellIndex = row.getFirstCellNum();
                while (cellIndex < cellNum) {
                    Cell cell = row.getCell(cellIndex);
                    int cellType = cell.getCellType();
                    String column = "";
                    switch (cellType) {
                        case 0: {
                            column = String.valueOf(cell.getDateCellValue());
                            break;
                        }
                        case 1: {
                            column = cell.getStringCellValue();
                            break;
                        }
                        case 4: {
                            column = String.valueOf(cell.getBooleanCellValue());
                            break;
                        }
                        case 2: {
                            column = cell.getCellFormula();
                            break;
                        }
                        case 3: 
                        case 5: {
                            column = " ";
                        }
                    }
                    columns.add(column.trim());
                    ++cellIndex;
                }
                ArrayList rowFilterFlagList = Lists.newArrayList();
                ArrayList rowFilterList = Lists.newArrayList();
                int k = 0;
                while (k < rowFilterList.size()) {
                    RowFilter rowFilter = (RowFilter)rowFilterList.get(k);
                    rowFilterFlagList.add(rowFilter.doFilter(rowIndex, columns));
                    ++k;
                }
                if (!rowFilterFlagList.contains(false)) {
                    sheetList.add(columns);
                }
                ++rowIndex;
            }
            result.add(sheetList);
            ++i;
        }
        return result;
    }

    public static List<List<String>> readSheet(File file, Rule Rule2) {
        return PoiImporter.readExcel(file, Rule2).get(0);
    }

    public static List<Model<?>> processSheet(File file, Rule Rule2, Class clazz) {
        List<List<String>> srcList = PoiImporter.readSheet(file, Rule2);
        ArrayList results = Lists.newArrayList();
        int i = 0;
        while (i < srcList.size()) {
            List<String> list = srcList.get(i);
            Model<?> model = PoiImporter.fillModel(clazz, list, Rule2);
            results.add(model);
            ++i;
        }
        return results;
    }

    public static Model<?> fillModel(Class<?> clazz, List<String> list, Rule rule) {
        Model model = (Model)Reflect.on(clazz).create().get();
        String[] values = list.toArray(new String[0]);
        String message = "";
        int i = 0;
        while (i < values.length) {
            CellValidate cellValidate;
            String value = values[i];
            Rule.Cell cell = PoiImporter.matchCell(rule, i);
            String name = cell.getAttribute();
            String validateClassName = cell.getValidate();
            boolean valid = true;
            if (StrKit.notBlank((String)validateClassName) && !(valid = (cellValidate = (CellValidate)Reflect.on(validateClassName).create().get()).validate(value))) {
                message = String.valueOf(message) + "value(" + value + ") is invalid in column " + cell.getIndex() + "</br>";
            }
            if (valid) {
                String convertedValue = value;
                String convertClassName = cell.getConvert();
                if (StrKit.notBlank((String)convertClassName)) {
                    CellConvert cellConvert = (CellConvert)Reflect.on(convertClassName).get();
                    convertedValue = cellConvert.convert(value, model);
                }
                model.set(name, (Object)convertedValue);
            }
            ++i;
        }
        if (StrKit.notBlank((String)message)) {
            throw new ExcelException(message);
        }
        return model;
    }

    public static Rule.Cell matchCell(Rule rule, int index) {
        List<Rule.Cell> cells = rule.getCells();
        int i = 0;
        while (i < cells.size()) {
            Rule.Cell cell = cells.get(i);
            if (index + 1 == cell.getIndex()) {
                return cell;
            }
            ++i;
        }
        return null;
    }
}

