/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.jms;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jfinal.ext.plugin.config.ConfigPlugin;
import com.jfinal.ext.plugin.jms.JmsConfig;
import com.jfinal.ext.plugin.jms.JmsKit;
import com.jfinal.ext.plugin.jms.JmsReceive;
import com.jfinal.ext.plugin.jms.JmsSender;
import com.jfinal.ext.plugin.jms.QueueListener;
import com.jfinal.ext.plugin.jms.QueueProducer;
import com.jfinal.ext.plugin.jms.ReceiveResolverFactory;
import com.jfinal.ext.plugin.jms.TopicListener;
import com.jfinal.ext.plugin.jms.TopicPublisher;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.IPlugin;
import java.util.List;
import javax.jms.MessageListener;

public class JmsPlugin
implements IPlugin {
    protected final Log logger = Log.getLog(this.getClass());
    private String resoruceLocation = "jms.properties";
    private ConfigPlugin configPlugin;
    private String serverUrl;
    private String username;
    private String password;
    private JmsSender jmsSender;
    private List<MessageListener> listeners = Lists.newArrayList();

    public JmsPlugin() {
    }

    public JmsPlugin(ConfigPlugin configPlugin) {
        this.configPlugin = configPlugin;
    }

    public JmsPlugin(String resoruceLocation) {
        this.resoruceLocation = resoruceLocation;
    }

    public JmsPlugin(String resoruceLocation, ConfigPlugin configPlugin) {
        this.resoruceLocation = resoruceLocation;
        this.configPlugin = configPlugin;
    }

    public boolean start() {
        JmsConfig.init(this.resoruceLocation, this.configPlugin);
        this.initServerConfig();
        this.initSender();
        this.initReceiver();
        this.iniJmsKit();
        return true;
    }

    private void iniJmsKit() {
        JmsKit.init(this.jmsSender);
    }

    private void initServerConfig() {
        this.serverUrl = JmsConfig.getStr("serverUrl");
        this.username = JmsConfig.getStr("username");
        this.password = JmsConfig.getStr("password");
        this.logger.debug("serverUrl : " + this.serverUrl + " ,username : " + this.username + " ,password : " + this.password);
    }

    private void initReceiver() {
        int n;
        String receiveQueues = JmsConfig.getStr("receiveQueues");
        this.logger.debug("receiveQueues :" + receiveQueues);
        if (StrKit.notBlank((String)receiveQueues)) {
            String[] stringArray = receiveQueues.split(",");
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String queueName = stringArray[n2];
                JmsReceive queueReceive = new JmsReceive(new ReceiveResolverFactory(this.resoruceLocation, "queue." + queueName));
                this.listeners.add(new QueueListener(this.serverUrl, this.username, this.password, queueName, queueReceive));
                ++n2;
            }
        }
        String receiveTopics = JmsConfig.getStr("receiveTopics");
        this.logger.debug("receiveTopic :" + receiveTopics);
        if (StrKit.notBlank((String)receiveTopics)) {
            String[] stringArray = receiveTopics.split(",");
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String topicName = stringArray[n];
                JmsReceive queueReceive = new JmsReceive(new ReceiveResolverFactory(this.resoruceLocation, "topic." + topicName));
                this.listeners.add(new TopicListener(this.serverUrl, this.username, this.password, topicName, queueReceive));
                ++n;
            }
        }
        this.logger.debug(this.listeners.toString());
    }

    private void initSender() {
        int n;
        this.jmsSender = new JmsSender();
        this.jmsSender.queueProducers = Maps.newHashMap();
        String sendQueues = JmsConfig.getStr("sendQueues");
        this.logger.debug("sendQueues :" + sendQueues);
        if (StrKit.notBlank((String)sendQueues)) {
            String[] stringArray = sendQueues.split(",");
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String queueName = stringArray[n2];
                this.jmsSender.queueProducers.put(queueName, new QueueProducer(this.serverUrl, this.username, this.password, queueName));
                ++n2;
            }
        }
        String sendTopics = JmsConfig.getStr("sendTopics");
        this.logger.debug("sendTopics :" + sendTopics);
        if (StrKit.notBlank((String)sendTopics)) {
            this.jmsSender.topicPublishers = Maps.newHashMap();
            String[] stringArray = sendTopics.split(",");
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String topicName = stringArray[n];
                this.jmsSender.topicPublishers.put(topicName, new TopicPublisher(this.serverUrl, this.username, this.password, topicName));
                ++n;
            }
        }
    }

    public boolean stop() {
        this.listeners.clear();
        return true;
    }
}

