/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.jms;

import com.jfinal.ext.plugin.jms.DefaultMessageHandler;
import com.jfinal.ext.plugin.jms.IMessageHandler;
import com.jfinal.log.Log;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;

public class TopicListener
implements MessageListener {
    protected final Log logger = Log.getLog(this.getClass());
    protected String serverUrl;
    protected String username;
    protected String password;
    protected String topicName;
    private Connection connection;
    private Session session;
    private Destination destination;
    private MessageConsumer consumer;
    private IMessageHandler messageHandler;

    public TopicListener(String serverUrl, String username, String password, String topicName, IMessageHandler messageHandler) {
        this.serverUrl = serverUrl;
        this.username = username;
        this.password = password;
        this.topicName = topicName;
        this.messageHandler = messageHandler;
        this.initListener();
    }

    private void initListener() {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.serverUrl);
            this.connection = connectionFactory.createConnection(this.username, this.password);
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.destination = this.session.createTopic(this.topicName);
            this.consumer = this.session.createConsumer(this.destination);
            this.consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            this.logger.error("init error", (Throwable)e);
        }
    }

    public void onMessage(Message message) {
        if (this.messageHandler != null) {
            this.logger.error("MessageHandler is null!please set a messageHandler");
            this.messageHandler.handleMessage(message);
        } else {
            new DefaultMessageHandler().handleMessage(message);
        }
    }

    public void closeConnection() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

