/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.jms;

import com.jfinal.log.Log;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;

public class TopicPublisher {
    protected final Log logger = Log.getLog(this.getClass());
    protected String serverUrl;
    protected String username;
    protected String password;
    protected String topicName;
    protected int reConnectTimes;
    protected int reConnectInterval;
    private Connection connection;
    private Session session;
    private Destination destination;
    private MessageProducer producer;

    public TopicPublisher(String serverUrl, String username, String password, String topicName) {
        this.serverUrl = serverUrl;
        this.username = username;
        this.password = password;
        this.topicName = topicName;
        this.initConnection();
    }

    public TopicPublisher(String serverUrl, String username, String password, String topicName, int reConnectTimes, int reConnectInterval) {
        this(serverUrl, username, password, topicName);
        this.reConnectTimes = reConnectTimes;
        this.reConnectInterval = reConnectInterval;
    }

    private void initConnection() {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.serverUrl);
        try {
            this.connection = factory.createConnection(this.username, this.password);
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.destination = this.session.createTopic(this.topicName);
            this.producer = this.session.createProducer(this.destination);
            this.producer.setTimeToLive(10L);
        }
        catch (JMSException e) {
            this.logger.error("init publisher error", (Throwable)e);
        }
    }

    public boolean publishMessage(Serializable object, int msgType) {
        block3: {
            try {
                if (this.session != null || this.reConnect()) break block3;
                this.logger.debug("cant connected to JMS server");
                return false;
            }
            catch (JMSException e) {
                this.logger.error("publish message error", (Throwable)e);
                return false;
            }
        }
        this.logger.debug("publish message, msg_type:" + msgType);
        ObjectMessage om = this.session.createObjectMessage(object);
        om.setIntProperty("msgType", msgType);
        this.producer.send((Message)om);
        return true;
    }

    private boolean reConnect() {
        int times = this.reConnectTimes;
        while (times-- > 0) {
            this.logger.debug("reConnectTimes" + times);
            this.initConnection();
            if (this.session != null) {
                return true;
            }
            try {
                TimeUnit.MINUTES.sleep(this.reConnectInterval);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public void closeConnection() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

