/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.redis;

import com.google.common.collect.Maps;
import com.jfinal.ext.plugin.redis.JedisKit;
import com.jfinal.ext.plugin.redis.JedisMessage;
import com.jfinal.log.Log;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class QueueConsumer {
    final Log LOG = Log.getLog(this.getClass());
    static final String SEPARATER = "-";
    static final String PROCESSINGLIST = "-processing";
    static final String PREFIX = "queue-";
    static Map<String, QueueConsumer> existingConsumers = Maps.newHashMap();
    int interval = 1000;
    boolean start = false;
    String queueName;

    private QueueConsumer(String queueName) {
        this.queueName = queueName;
    }

    public static QueueConsumer create(String queueName) {
        QueueConsumer consumer = existingConsumers.get(queueName);
        if (consumer != null) {
            throw new IllegalArgumentException("The consumer named " + queueName + " already exists");
        }
        consumer = new QueueConsumer(queueName);
        return consumer;
    }

    public QueueConsumer interval(int interval) {
        this.interval = interval;
        return this;
    }

    private void waitForMessages() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.interval);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public <T extends Serializable> T consume() {
        return JedisKit.rpoplpush(this.queueName(), this.processingListName());
    }

    public void consume(final JedisMessage callback) {
        if (this.start) {
            throw new RuntimeException("The Consumer named " + this.queueName + " is working");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    JedisKit.rpoplpush(QueueConsumer.this.queueName(), QueueConsumer.this.processingListName());
                    List message = JedisKit.lrange(QueueConsumer.this.processingListName(), -1L, -1L);
                    if (message.isEmpty()) {
                        QueueConsumer.this.waitForMessages();
                        continue;
                    }
                    callback.onMessage((Serializable)message.get(0));
                    JedisKit.rpop(QueueConsumer.this.processingListName());
                }
            }
        }).start();
    }

    private String processingListName() {
        return PREFIX + this.queueName + PROCESSINGLIST;
    }

    private String queueName() {
        return PREFIX + this.queueName;
    }
}

