/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.shiro;

import com.jfinal.ext.plugin.shiro.AbstractAuthzHandler;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;

class RoleAuthzHandler
extends AbstractAuthzHandler {
    private final Annotation annotation;

    public RoleAuthzHandler(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public void assertAuthorized() throws AuthorizationException {
        RequiresRoles rrAnnotation = (RequiresRoles)this.annotation;
        String[] roles = rrAnnotation.value();
        if (roles.length == 1) {
            this.getSubject().checkRole(roles[0]);
            return;
        }
        if (Logical.AND.equals((Object)rrAnnotation.logical())) {
            this.getSubject().checkRoles(Arrays.asList(roles));
            return;
        }
        if (Logical.OR.equals((Object)rrAnnotation.logical())) {
            boolean hasAtLeastOneRole = false;
            String[] stringArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                if (this.getSubject().hasRole(role)) {
                    hasAtLeastOneRole = true;
                }
                ++n2;
            }
            if (!hasAtLeastOneRole) {
                this.getSubject().checkRole(roles[0]);
            }
        }
    }
}

