/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.shiro;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.ext.plugin.shiro.AuthzHandler;
import com.jfinal.ext.plugin.shiro.ShiroKit;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;

public class ShiroInterceptor
implements Interceptor {
    public void intercept(Invocation ai) {
        AuthzHandler ah = ShiroKit.getAuthzHandler(ai.getActionKey());
        if (ah != null) {
            try {
                ah.assertAuthorized();
            }
            catch (UnauthenticatedException lae) {
                ai.getController().renderError(401);
                return;
            }
            catch (AuthorizationException ae) {
                ai.getController().renderError(403);
                return;
            }
            catch (Exception e) {
                ai.getController().renderError(401);
                return;
            }
        }
        ai.invoke();
    }
}

