/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.shiro;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroMethod {
    private static final String NAMES_DELIMETER = ",";

    private ShiroMethod() {
    }

    protected static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static boolean hasRole(String roleName) {
        return ShiroMethod.getSubject() != null && roleName != null && roleName.length() > 0 && ShiroMethod.getSubject().hasRole(roleName);
    }

    public static boolean lacksRole(String roleName) {
        return !ShiroMethod.hasRole(roleName);
    }

    public static boolean hasAnyRoles(String roleNames) {
        boolean hasAnyRole = false;
        Subject subject = ShiroMethod.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            String[] stringArray = roleNames.split(NAMES_DELIMETER);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                if (subject.hasRole(role.trim())) {
                    hasAnyRole = true;
                    break;
                }
                ++n2;
            }
        }
        return hasAnyRole;
    }

    public static boolean hasAllRoles(String roleNames) {
        boolean hasAllRole = true;
        Subject subject = ShiroMethod.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            String[] stringArray = roleNames.split(NAMES_DELIMETER);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                if (!subject.hasRole(role.trim())) {
                    hasAllRole = false;
                    break;
                }
                ++n2;
            }
        }
        return hasAllRole;
    }

    public static boolean hasPermission(String permission) {
        return ShiroMethod.getSubject() != null && permission != null && permission.length() > 0 && ShiroMethod.getSubject().isPermitted(permission);
    }

    public static boolean lacksPermission(String permission) {
        return !ShiroMethod.hasPermission(permission);
    }

    public static boolean authenticated() {
        return ShiroMethod.getSubject() != null && ShiroMethod.getSubject().isAuthenticated();
    }

    public static boolean notAuthenticated() {
        return !ShiroMethod.authenticated();
    }

    public static boolean user() {
        return ShiroMethod.getSubject() != null && ShiroMethod.getSubject().getPrincipal() != null;
    }

    public static boolean guest() {
        return !ShiroMethod.user();
    }

    public String principal() {
        if (ShiroMethod.getSubject() != null) {
            Object principal = ShiroMethod.getSubject().getPrincipal();
            return principal.toString();
        }
        return "Guest";
    }
}

