/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.shiro;

import com.jfinal.config.Routes;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Controller;
import com.jfinal.ext.plugin.shiro.AuthenticatedAuthzHandler;
import com.jfinal.ext.plugin.shiro.AuthzHandler;
import com.jfinal.ext.plugin.shiro.ClearShiro;
import com.jfinal.ext.plugin.shiro.CompositeAuthzHandler;
import com.jfinal.ext.plugin.shiro.GuestAuthzHandler;
import com.jfinal.ext.plugin.shiro.PermissionAuthzHandler;
import com.jfinal.ext.plugin.shiro.RoleAuthzHandler;
import com.jfinal.ext.plugin.shiro.ShiroKit;
import com.jfinal.ext.plugin.shiro.UserAuthzHandler;
import com.jfinal.plugin.IPlugin;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;

public class ShiroPlugin
implements IPlugin {
    private static final String SLASH = "/";
    private static final Class<? extends Annotation>[] AUTHZ_ANNOTATION_CLASSES = new Class[]{RequiresPermissions.class, RequiresRoles.class, RequiresUser.class, RequiresGuest.class, RequiresAuthentication.class};
    private final Routes routes;

    public ShiroPlugin(Routes routes) {
        this.routes = routes;
    }

    public boolean stop() {
        return true;
    }

    public boolean start() {
        Set<String> excludedMethodName = this.buildExcludedMethodName();
        ConcurrentHashMap<String, AuthzHandler> authzMaps = new ConcurrentHashMap<String, AuthzHandler>();
        for (Map.Entry entry : this.routes.getEntrySet()) {
            Method[] methods;
            Class controllerClass = (Class)entry.getValue();
            String controllerKey = (String)entry.getKey();
            List<Annotation> controllerAnnotations = this.getAuthzAnnotations(controllerClass);
            Method[] methodArray = methods = controllerClass.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                List<Annotation> methodAnnotations;
                AuthzHandler authzHandler;
                Method method = methodArray[n2];
                if (!excludedMethodName.contains(method.getName()) && method.getParameterTypes().length == 0 && !this.isClearShiroAnnotationPresent(method) && (authzHandler = this.createAuthzHandler(controllerAnnotations, methodAnnotations = this.getAuthzAnnotations(method))) != null) {
                    String actionKey = this.createActionKey(controllerClass, method, controllerKey);
                    authzMaps.put(actionKey, authzHandler);
                }
                ++n2;
            }
        }
        ShiroKit.init(authzMaps);
        return true;
    }

    private Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>();
        Method[] methodArray = methods = Controller.class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getParameterTypes().length == 0) {
                excludedMethodName.add(m.getName());
            }
            ++n2;
        }
        return excludedMethodName;
    }

    private AuthzHandler createAuthzHandler(List<Annotation> controllerAnnotations, List<Annotation> methodAnnotations) {
        if (controllerAnnotations.size() == 0 && methodAnnotations.size() == 0) {
            return null;
        }
        ArrayList<AuthzHandler> authzHandlers = new ArrayList<AuthzHandler>(5);
        int index = 0;
        while (index < 5) {
            authzHandlers.add(null);
            ++index;
        }
        this.scanAnnotation(authzHandlers, controllerAnnotations);
        this.scanAnnotation(authzHandlers, methodAnnotations);
        ArrayList<AuthzHandler> finalAuthzHandlers = new ArrayList<AuthzHandler>();
        for (AuthzHandler a : authzHandlers) {
            if (a == null) continue;
            finalAuthzHandlers.add(a);
        }
        authzHandlers = null;
        if (finalAuthzHandlers.size() > 1) {
            return new CompositeAuthzHandler(finalAuthzHandlers);
        }
        return (AuthzHandler)finalAuthzHandlers.get(0);
    }

    private void scanAnnotation(List<AuthzHandler> authzArray, List<Annotation> annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        for (Annotation a : annotations) {
            if (a instanceof RequiresRoles) {
                authzArray.set(0, new RoleAuthzHandler(a));
                continue;
            }
            if (a instanceof RequiresPermissions) {
                authzArray.set(1, new PermissionAuthzHandler(a));
                continue;
            }
            if (a instanceof RequiresAuthentication) {
                authzArray.set(2, AuthenticatedAuthzHandler.me());
                continue;
            }
            if (a instanceof RequiresUser) {
                authzArray.set(3, UserAuthzHandler.me());
                continue;
            }
            if (!(a instanceof RequiresGuest)) continue;
            authzArray.set(4, GuestAuthzHandler.me());
        }
    }

    private String createActionKey(Class<? extends Controller> controllerClass, Method method, String controllerKey) {
        String methodName = method.getName();
        String actionKey = "";
        ActionKey ak = method.getAnnotation(ActionKey.class);
        if (ak != null) {
            actionKey = ak.value().trim();
            if ("".equals(actionKey)) {
                throw new IllegalArgumentException(String.valueOf(controllerClass.getName()) + "." + methodName + "(): The argument of ActionKey can not be blank.");
            }
            if (!actionKey.startsWith(SLASH)) {
                actionKey = SLASH + actionKey;
            }
        } else {
            actionKey = methodName.equals("index") ? controllerKey : (controllerKey.equals(SLASH) ? SLASH + methodName : String.valueOf(controllerKey) + SLASH + methodName);
        }
        return actionKey;
    }

    private List<Annotation> getAuthzAnnotations(Method method) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Class<? extends Annotation>[] classArray = AUTHZ_ANNOTATION_CLASSES;
        int n = AUTHZ_ANNOTATION_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> annClass = classArray[n2];
            Annotation a = method.getAnnotation(annClass);
            if (a != null) {
                annotations.add(a);
            }
            ++n2;
        }
        return annotations;
    }

    private List<Annotation> getAuthzAnnotations(Class<? extends Controller> targetClass) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Class<? extends Annotation>[] classArray = AUTHZ_ANNOTATION_CLASSES;
        int n = AUTHZ_ANNOTATION_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> annClass = classArray[n2];
            Annotation a = targetClass.getAnnotation(annClass);
            if (a != null) {
                annotations.add(a);
            }
            ++n2;
        }
        return annotations;
    }

    private boolean isClearShiroAnnotationPresent(Method method) {
        ClearShiro a = method.getAnnotation(ClearShiro.class);
        return a != null;
    }
}

