/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.sqlinxml;

import com.jfinal.ext.kit.JaxbKit;
import com.jfinal.ext.plugin.sqlinxml.SqlGroup;
import com.jfinal.ext.plugin.sqlinxml.SqlItem;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;

public class SqlKit {
    protected static final Log LOG = Log.getLog(SqlKit.class);
    private static Map<String, String> sqlMap;

    public static String sql(String groupNameAndsqlId) {
        if (sqlMap == null) {
            throw new NullPointerException("SqlInXmlPlugin not start");
        }
        return sqlMap.get(groupNameAndsqlId);
    }

    static void clearSqlMap() {
        sqlMap.clear();
    }

    static void init() {
        File[] files;
        sqlMap = new HashMap<String, String>();
        File file = new File(PathKit.getRootClassPath());
        File[] fileArray = files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("sql.xml");
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlfile = fileArray[n2];
            SqlGroup group = JaxbKit.unmarshal(xmlfile, SqlGroup.class);
            String name = group.name;
            if (name == null || name.trim().equals("")) {
                name = xmlfile.getName();
            }
            for (SqlItem sqlItem : group.sqlItems) {
                sqlMap.put(String.valueOf(name) + "." + sqlItem.id, sqlItem.value);
            }
            ++n2;
        }
        LOG.debug("sqlMap" + sqlMap);
    }
}

