/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.tablebind;

import com.google.common.collect.Lists;
import com.jfinal.ext.kit.ClassSearcher;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.ext.plugin.tablebind.INameStyle;
import com.jfinal.ext.plugin.tablebind.SimpleNameStyles;
import com.jfinal.ext.plugin.tablebind.TableBind;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.Model;
import java.io.File;
import java.util.List;
import javax.sql.DataSource;

public class AutoTableBindPlugin
extends ActiveRecordPlugin {
    protected final Log log = Log.getLog(((Object)((Object)this)).getClass());
    private List<Class<? extends Model>> excludeClasses = Lists.newArrayList();
    private List<String> includeJars = Lists.newArrayList();
    private boolean autoScan = true;
    private boolean includeAllJarsInLib = false;
    private List<String> scanPackages = Lists.newArrayList();
    private INameStyle nameStyle;
    private String classpath = PathKit.getRootClassPath();
    private String libDir = String.valueOf(PathKit.getWebRootPath()) + File.separator + "WEB-INF" + File.separator + "lib";

    public AutoTableBindPlugin(IDataSourceProvider dataSourceProvider) {
        this("main", dataSourceProvider, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(String configName, IDataSourceProvider dataSourceProvider) {
        this(configName, dataSourceProvider, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(IDataSourceProvider dataSourceProvider, int transactionLevel) {
        this("main", dataSourceProvider, transactionLevel, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(String configName, IDataSourceProvider dataSourceProvider, int transactionLevel) {
        this(configName, dataSourceProvider, transactionLevel, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(IDataSourceProvider dataSourceProvider, INameStyle nameStyle) {
        super("main", dataSourceProvider);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin(String configName, IDataSourceProvider dataSourceProvider, INameStyle nameStyle) {
        super(configName, dataSourceProvider);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin(IDataSourceProvider dataSourceProvider, int transactionLevel, INameStyle nameStyle) {
        super("main", dataSourceProvider, transactionLevel);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin(String configName, IDataSourceProvider dataSourceProvider, int transactionLevel, INameStyle nameStyle) {
        super(configName, dataSourceProvider, transactionLevel);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin(DataSource dataSource) {
        this("main", dataSource, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(String configName, DataSource dataSource) {
        this(configName, dataSource, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(DataSource dataSource, int transactionLevel) {
        this("main", dataSource, transactionLevel, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(String configName, DataSource dataSource, int transactionLevel) {
        this(configName, dataSource, transactionLevel, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(DataSource dataSource, INameStyle nameStyle) {
        super("main", dataSource);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin(String configName, DataSource dataSource, INameStyle nameStyle) {
        super(configName, dataSource);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin(DataSource dataSource, int transactionLevel, INameStyle nameStyle) {
        super("main", dataSource, transactionLevel);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin(String configName, DataSource dataSource, int transactionLevel, INameStyle nameStyle) {
        super(configName, dataSource, transactionLevel);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin addScanPackages(String ... packages) {
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            this.scanPackages.add(pkg);
            ++n2;
        }
        return this;
    }

    public AutoTableBindPlugin addExcludeClasses(Class<? extends Model> ... clazzes) {
        Class<? extends Model>[] classArray = clazzes;
        int n = clazzes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Model> clazz = classArray[n2];
            this.excludeClasses.add(clazz);
            ++n2;
        }
        return this;
    }

    public AutoTableBindPlugin addExcludeClasses(List<Class<? extends Model>> clazzes) {
        if (clazzes != null) {
            this.excludeClasses.addAll(clazzes);
        }
        return this;
    }

    public AutoTableBindPlugin addJars(List<String> jars) {
        if (jars != null) {
            this.includeJars.addAll(jars);
        }
        return this;
    }

    public AutoTableBindPlugin addJars(String ... jars) {
        if (jars != null) {
            String[] stringArray = jars;
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                String jar = stringArray[n2];
                this.includeJars.add(jar);
                ++n2;
            }
        }
        return this;
    }

    public boolean start() {
        List modelClasses = ClassSearcher.of(Model.class).libDir(this.libDir).classpath(this.classpath).scanPackages(this.scanPackages).injars(this.includeJars).includeAllJarsInLib(this.includeAllJarsInLib).search();
        for (Class modelClass : modelClasses) {
            String tableName;
            if (this.excludeClasses.contains(modelClass)) continue;
            TableBind tb = modelClass.getAnnotation(TableBind.class);
            String arpConfName = (String)Reflect.on((Object)this).get("configName");
            if (tb == null) {
                if (!this.autoScan) continue;
                tableName = this.nameStyle.name(modelClass.getSimpleName());
                this.addMapping(tableName, modelClass);
                this.log.debug(String.valueOf(arpConfName) + " addMapping(" + tableName + ", " + modelClass.getName() + ")");
                continue;
            }
            String tbConfName = tb.configName();
            if (StrKit.notBlank((String)tbConfName) && !tbConfName.equals(arpConfName)) continue;
            tableName = tb.tableName();
            if (StrKit.notBlank((String)tb.pkName())) {
                this.addMapping(tableName, tb.pkName(), modelClass);
                this.log.debug(String.valueOf(arpConfName) + " addMapping(" + tableName + ", " + tb.pkName() + "," + modelClass.getName() + ")");
                continue;
            }
            this.addMapping(tableName, modelClass);
            this.log.debug(String.valueOf(arpConfName) + " addMapping(" + tableName + ", " + modelClass.getName() + ")");
        }
        return super.start();
    }

    public boolean stop() {
        return super.stop();
    }

    public AutoTableBindPlugin autoScan(boolean autoScan) {
        this.autoScan = autoScan;
        return this;
    }

    public AutoTableBindPlugin classpath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    public AutoTableBindPlugin libDir(String libDir) {
        this.libDir = libDir;
        return this;
    }

    public AutoTableBindPlugin includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }
}

