/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render;

import com.google.common.base.Throwables;
import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.RenderException;
import freemarker.template.Template;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;

public class FreeMarkerXMLRender
extends FreeMarkerRender {
    private static final String CONTENT_TYPE = "text/xml; charset=" + FreeMarkerXMLRender.getEncoding();

    public FreeMarkerXMLRender(String view) {
        super(view);
    }

    public void render() {
        this.response.setContentType(CONTENT_TYPE);
        Enumeration attrs = this.request.getAttributeNames();
        HashMap<String, Object> root = new HashMap<String, Object>();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            root.put(attrName, this.request.getAttribute(attrName));
        }
        PrintWriter writer = null;
        try {
            try {
                writer = this.response.getWriter();
                Template template = FreeMarkerXMLRender.getConfiguration().getTemplate(this.view);
                template.process(root, (Writer)writer);
            }
            catch (Exception e) {
                throw new RenderException((Throwable)e);
            }
        }
        finally {
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }
}

