/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render.chart.amchart;

import com.jfinal.ext.kit.KeyLabel;
import com.jfinal.ext.render.chart.amchart.AmChartsConstans;
import com.jfinal.ext.render.chart.amchart.Creater;
import com.jfinal.ext.render.chart.amchart.GraphChart;
import com.jfinal.ext.render.chart.amchart.PieChart;
import com.jfinal.log.Log;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class AmChartsRender
extends Render
implements AmChartsConstans {
    public static int globalHeight = 600;
    public static int globalWidth = 400;
    private static final String CONTENT_TYPE = "text/html;charset=" + AmChartsRender.getEncoding();
    private Log logger = Log.getLog(AmChartsRender.class);
    private List<?> data;
    private List<String> series;
    private List<KeyLabel> pies;
    private int height;
    private int width;
    private String path = "/amcharts";
    private String flashFile;
    private String settingsFile;
    private String title;
    private String chartXml;
    private String type;

    public AmChartsRender(String type, int height, int width, String flashFile, String settingsFile) {
        this.type = type;
        this.height = height;
        this.width = width;
        this.flashFile = flashFile;
        this.settingsFile = settingsFile;
    }

    public static AmChartsRender pie(List<KeyLabel> pies, String flashFile, String settingsFile) {
        AmChartsRender render = AmChartsRender.pie(pies, flashFile, settingsFile, 0, 0);
        return render;
    }

    public static AmChartsRender pie(List<KeyLabel> pies, String flashFile, String settingsFile, int height, int width) {
        AmChartsRender render = new AmChartsRender("pie", height > 0 ? height : globalHeight, width > 0 ? width : globalWidth, flashFile, settingsFile);
        render.setPies(pies);
        return render;
    }

    public static AmChartsRender graph(List<?> data, List<String> series, String flashFile, String settingsFile) {
        return AmChartsRender.graph(data, series, flashFile, settingsFile, 0, 0);
    }

    public static AmChartsRender graph(List<?> data, List<String> series, String flashFile, String settingsFile, int height, int width) {
        AmChartsRender render = new AmChartsRender("graph", height > 0 ? height : globalHeight, width > 0 ? width : globalWidth, flashFile, settingsFile);
        render.setData(data);
        render.setSeries(series);
        return render;
    }

    public void render() {
        this.genChartXml();
        StringBuffer chart = new StringBuffer();
        chart.append("<html><head><meta http-equiv='Content-Type' content='text/html; charset=UTF-8'><title>amCharts Example</title></head><body style='background-color:#EEEEEE'>").append("<script type='text/javascript' src='").append(String.valueOf(this.request.getContextPath()) + this.path).append("/flash/swfobject.js'></script><div id='chartdiv'></div><script type='text/javascript'>").append("var params = {bgcolor:'#FFFFFF'}; var flashVars = {path: '").append(String.valueOf(this.request.getContextPath()) + this.path).append("/flash/',settings_file:  encodeURIComponent('").append(String.valueOf(this.request.getContextPath()) + "/amcharts/amchartSettings/").append(this.settingsFile).append("'),").append("chart_data: \"").append(this.chartXml).append("\"};").append("swfobject.embedSWF('").append(String.valueOf(this.request.getContextPath()) + this.path).append("/flash/").append(this.flashFile).append("', 'chartdiv', '").append(this.width).append("', '").append(this.height).append("', '8.0.0', '").append(String.valueOf(this.request.getContextPath()) + this.path).append("/flash/expressInstall.swf', flashVars, params);</script></body></html>");
        try (PrintWriter writer = null;){
            try {
                this.response.setHeader("Pragma", "no-cache");
                this.response.setHeader("Cache-Control", "no-cache");
                this.response.setDateHeader("Expires", 0L);
                this.response.setContentType(CONTENT_TYPE);
                writer = this.response.getWriter();
                this.logger.debug("chart: " + chart.toString());
                writer.write(chart.toString());
                writer.flush();
            }
            catch (IOException e) {
                throw new RenderException((Throwable)e);
            }
        }
    }

    private void genChartXml() {
        if ("graph".equals(this.type)) {
            GraphChart multipleChart = new GraphChart();
            multipleChart.setSeriesNames(this.series);
            multipleChart.setValues(this.data);
            this.chartXml = Creater.createMultipleChart(multipleChart);
        } else if ("pie".equals(this.type)) {
            PieChart pieChart = new PieChart();
            pieChart.setPies(this.pies);
            this.chartXml = Creater.createPieChart(pieChart);
        }
    }

    public static int getGlobalHeight() {
        return globalHeight;
    }

    public static void setGlobalHeight(int globalHeight) {
        AmChartsRender.globalHeight = globalHeight;
    }

    public static int getGlobalWidth() {
        return globalWidth;
    }

    public static void setGlobalWidth(int globalWidth) {
        AmChartsRender.globalWidth = globalWidth;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public List<?> getData() {
        return this.data;
    }

    public void setData(List<?> data) {
        this.data = data;
    }

    public List<String> getSeries() {
        return this.series;
    }

    public void setSeries(List<String> series) {
        this.series = series;
    }

    public List<KeyLabel> getPies() {
        return this.pies;
    }

    public void setPies(List<KeyLabel> pies) {
        this.pies = pies;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFlashFile() {
        return this.flashFile;
    }

    public void setFlashFile(String flashFile) {
        this.flashFile = flashFile;
    }

    public String getSettingsFile() {
        return this.settingsFile;
    }

    public void setSettingsFile(String settingsFile) {
        this.settingsFile = settingsFile;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getChartXml() {
        return this.chartXml;
    }

    public void setChartXml(String chartXml) {
        this.chartXml = chartXml;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

