/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.route;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.ext.kit.ClassSearcher;
import com.jfinal.ext.route.ControllerBind;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import java.util.List;

public class AutoBindRoutes
extends Routes {
    private boolean autoScan = true;
    private List<Class<? extends Controller>> excludeClasses = Lists.newArrayList();
    private boolean includeAllJarsInLib;
    private List<String> includeJars = Lists.newArrayList();
    protected final Log logger = Log.getLog(((Object)((Object)this)).getClass());
    private String suffix = "Controller";

    public AutoBindRoutes autoScan(boolean autoScan) {
        this.autoScan = autoScan;
        return this;
    }

    public AutoBindRoutes addExcludeClasses(Class<? extends Controller> ... clazzes) {
        if (clazzes != null) {
            Class<? extends Controller>[] classArray = clazzes;
            int n = clazzes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Controller> clazz = classArray[n2];
                this.excludeClasses.add(clazz);
                ++n2;
            }
        }
        return this;
    }

    public AutoBindRoutes addExcludeClasses(List<Class<? extends Controller>> clazzes) {
        this.excludeClasses.addAll(clazzes);
        return this;
    }

    public AutoBindRoutes addJars(String ... jars) {
        if (jars != null) {
            String[] stringArray = jars;
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                String jar = stringArray[n2];
                this.includeJars.add(jar);
                ++n2;
            }
        }
        return this;
    }

    public void config() {
        List controllerClasses = ClassSearcher.of(Controller.class).includeAllJarsInLib(this.includeAllJarsInLib).injars(this.includeJars).search();
        ControllerBind controllerBind = null;
        for (Class<Controller> clazz : controllerClasses) {
            if (this.excludeClasses.contains(clazz)) continue;
            controllerBind = clazz.getAnnotation(ControllerBind.class);
            if (controllerBind == null) {
                if (!this.autoScan) continue;
                this.add(this.controllerKey(clazz), clazz);
                this.logger.debug("routes.add(" + this.controllerKey(clazz) + ", " + clazz.getName() + ")");
                continue;
            }
            if (StrKit.isBlank((String)controllerBind.viewPath())) {
                this.add(controllerBind.controllerKey(), clazz);
                this.logger.debug("routes.add(" + controllerBind.controllerKey() + ", " + clazz.getName() + ")");
                continue;
            }
            this.add(controllerBind.controllerKey(), clazz, controllerBind.viewPath());
            this.logger.debug("routes.add(" + controllerBind.controllerKey() + ", " + clazz + "," + controllerBind.viewPath() + ")");
        }
    }

    private String controllerKey(Class<Controller> clazz) {
        Preconditions.checkArgument((boolean)clazz.getSimpleName().endsWith(this.suffix), (Object)(String.valueOf(clazz.getName()) + " is not annotated with @ControllerBind and not end with " + this.suffix));
        String controllerKey = "/" + StrKit.firstCharToLowerCase((String)clazz.getSimpleName());
        controllerKey = controllerKey.substring(0, controllerKey.indexOf(this.suffix));
        return controllerKey;
    }

    public AutoBindRoutes includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }

    public AutoBindRoutes suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }
}

