/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.config;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.wall.WallFilter;
import com.jfinal.aop.Interceptor;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.ext.interceptor.POST;
import com.jfinal.ext.route.AutoBindRoutes;
import com.jfinal.ext2.handler.ActionExtentionHandler;
import com.jfinal.ext2.interceptor.NotFoundActionInterceptor;
import com.jfinal.ext2.interceptor.OnExceptionInterceptorExt;
import com.jfinal.ext2.kit.PageViewKit;
import com.jfinal.ext2.plugin.activerecord.generator.ModelGeneratorExt;
import com.jfinal.ext2.plugin.druid.DruidEncryptPlugin;
import com.jfinal.ext2.upload.filerenamepolicy.RandomFileRenamePolicy;
import com.jfinal.handler.Handler;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.generator.BaseModelGenerator;
import com.jfinal.plugin.activerecord.generator.Generator;
import com.jfinal.plugin.activerecord.generator.ModelGenerator;
import com.jfinal.plugin.druid.DruidPlugin;
import com.jfinal.render.ViewType;
import com.jfinal.upload.OreillyCos;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class JFinalConfigExt
extends JFinalConfig {
    private static final String cfg = "cfg.txt";
    public static String APP_NAME = null;
    protected boolean geRuned = true;
    private static final String ACTIVE_TEMPLATE = "db.%s.active";
    private static final String URL_TEMPLATE = "jdbc:%s://%s";
    private static final String USER_TEMPLATE = "db.%s.user";
    private static final String PASSWORD_TEMPLATE = "db.%s.password";
    private static final String INITSIZE_TEMPLATE = "db.%s.initsize";
    private static final String MAXSIZE_TEMPLATE = "db.%s.maxactive";
    private String modelPackage = null;
    private String modelOutDir = null;
    private String baseModelPackage = null;
    private String baseModelOutDir = null;

    public abstract void configMoreConstants(Constants var1);

    public abstract void configMoreRoutes(Routes var1);

    public abstract void configMorePlugins(Plugins var1);

    public abstract void configTablesMapping(String var1, ActiveRecordPlugin var2);

    public abstract void configMoreInterceptors(Interceptors var1);

    public abstract void configMoreHandlers(Handlers var1);

    public abstract void afterJFinalStarted();

    public void configConstant(Constants me) {
        me.setViewType(ViewType.JSP);
        me.setDevMode(this.getAppDevMode());
        me.setEncoding("UTF-8");
        me.setError404View(PageViewKit.get404PageView());
        me.setError500View(PageViewKit.get500PageView());
        me.setError403View(PageViewKit.get403PageView());
        me.setBaseUploadPath(this.getUploadPath());
        me.setBaseDownloadPath(this.getDownloadPath());
        APP_NAME = this.getAppName();
        OreillyCos.setFileRenamePolicy((FileRenamePolicy)new RandomFileRenamePolicy());
        this.configMoreConstants(me);
    }

    public void configRoute(Routes me) {
        me.add((Routes)new AutoBindRoutes());
        this.configMoreRoutes(me);
    }

    public void configPlugin(Plugins me) {
        String[] dses;
        String[] stringArray = dses = this.getDataSource();
        int n = dses.length;
        int n2 = 0;
        while (n2 < n) {
            String ds = stringArray[n2];
            if (this.getDbActiveState(ds)) {
                DruidEncryptPlugin drp = this.getDruidPlugin(ds);
                me.add((IPlugin)drp);
                ActiveRecordPlugin arp = this.getActiveRecordPlugin(ds, drp);
                me.add((IPlugin)arp);
                this.configTablesMapping(ds, arp);
            }
            ++n2;
        }
        this.configMorePlugins(me);
    }

    public void configInterceptor(Interceptors me) {
        me.add((Interceptor)new NotFoundActionInterceptor());
        me.add((Interceptor)new OnExceptionInterceptorExt());
        if (this.getHttpPostMethod()) {
            me.add((Interceptor)new POST());
        }
        this.configMoreInterceptors(me);
    }

    public void configHandler(Handlers me) {
        me.add((Handler)new ActionExtentionHandler());
        this.configMoreHandlers(me);
    }

    public void afterJFinalStart() {
        super.afterJFinalStart();
        this.afterJFinalStarted();
    }

    private void loadPropertyFile() {
        if (this.prop == null) {
            this.loadPropertyFile(cfg);
        }
    }

    private boolean getHttpPostMethod() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("app.post", false);
    }

    private String getPath(String property) {
        if (StrKit.isBlank((String)property) || !"downloads".equals(property) && !"uploads".equals(property)) {
            throw new IllegalArgumentException("property is invalid, property just use `downloads` or `uploads`");
        }
        this.loadPropertyFile();
        String app = this.getAppName();
        String baseDir = this.getProperty(String.format("app.%s.basedir", property));
        if (baseDir.endsWith("/")) {
            if (!baseDir.endsWith(String.valueOf(property) + "/")) {
                baseDir = String.valueOf(baseDir) + property + "/";
            }
        } else {
            baseDir = !baseDir.endsWith(property) ? String.valueOf(baseDir) + "/" + property + "/" : String.valueOf(baseDir) + "/";
        }
        return baseDir + app;
    }

    private String getUploadPath() {
        return this.getPath("uploads");
    }

    private String getDownloadPath() {
        return this.getPath("downloads");
    }

    private boolean getAppDevMode() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("app.dev", true);
    }

    private String getAppName() {
        this.loadPropertyFile();
        String appName = this.getProperty("app.name");
        if (StrKit.isBlank((String)appName)) {
            throw new IllegalArgumentException("Please Set Your App Name in Your cfg file");
        }
        return appName;
    }

    private boolean getDbActiveState(String ds) {
        this.loadPropertyFile();
        return this.getPropertyToBoolean(String.format(ACTIVE_TEMPLATE, ds), false);
    }

    private String[] getDataSource() {
        this.loadPropertyFile();
        String ds = this.getProperty("db.ds");
        if (StrKit.isBlank((String)ds)) {
            return new String[0];
        }
        if (ds.contains("\uff0c")) {
            new IllegalArgumentException("Cannot use \uff0cin ds");
        }
        return ds.split(",");
    }

    private DruidEncryptPlugin getDruidPlugin(String ds) {
        this.loadPropertyFile();
        String url = this.getProperty(String.format("db.%s.url", ds));
        url = String.format(URL_TEMPLATE, ds, url);
        if (!url.endsWith("?characterEncoding=UTF8&zeroDateTimeBehavior=convertToNull")) {
            url = String.valueOf(url) + "?characterEncoding=UTF8&zeroDateTimeBehavior=convertToNull";
        }
        DruidEncryptPlugin dp = new DruidEncryptPlugin(url, this.getProperty(String.format(USER_TEMPLATE, ds)), this.getProperty(String.format(PASSWORD_TEMPLATE, ds)));
        dp.setInitialSize(this.getPropertyToInt(String.format(INITSIZE_TEMPLATE, ds)));
        dp.setMaxActive(this.getPropertyToInt(String.format(MAXSIZE_TEMPLATE, ds)));
        dp.addFilter((Filter)new StatFilter());
        WallFilter wall = new WallFilter();
        wall.setDbType(ds);
        dp.addFilter((Filter)wall);
        if (!this.geRuned) {
            dp.start();
            BaseModelGenerator baseGe = new BaseModelGenerator(this.getBaseModelPackage(), this.getBaseModelOutDir());
            ModelGeneratorExt modelGe = new ModelGeneratorExt(this.getModelPackage(), this.getBaseModelPackage(), this.getModelOutDir());
            Generator ge = new Generator(dp.getDataSource(), baseGe, (ModelGenerator)modelGe);
            ge.setGenerateDataDictionary(this.getGeDictionary());
            ge.generate();
        }
        return dp;
    }

    private ActiveRecordPlugin getActiveRecordPlugin(String ds, DruidPlugin dp) {
        this.loadPropertyFile();
        ActiveRecordPlugin arp = new ActiveRecordPlugin(ds, (IDataSourceProvider)dp);
        arp.setShowSql(this.getPropertyToBoolean("db.showsql").booleanValue());
        try {
            Class<?> clazz = Class.forName(String.valueOf(this.getModelPackage()) + "._MappingKit");
            Method mapping = clazz.getMethod("mapping", ActiveRecordPlugin.class);
            mapping.invoke(clazz, arp);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            try {
                throw e;
            }
            catch (Exception e1) {
                throw new RuntimeException(String.valueOf(e1));
            }
        }
        return arp;
    }

    private boolean getGeDictionary() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("ge.dict", false);
    }

    private String getBaseModelOutDir() {
        this.loadPropertyFile();
        if (this.baseModelOutDir == null) {
            this.baseModelOutDir = this.getProperty("ge.base.model.outdir");
        }
        return this.baseModelOutDir;
    }

    private String getBaseModelPackage() {
        this.loadPropertyFile();
        if (this.baseModelPackage == null) {
            this.baseModelPackage = this.getProperty("ge.base.model.package");
        }
        return this.baseModelPackage;
    }

    private String getModelOutDir() {
        this.loadPropertyFile();
        if (this.modelOutDir == null) {
            this.modelOutDir = this.getProperty("ge.model.outdir");
        }
        return this.modelOutDir;
    }

    private String getModelPackage() {
        this.loadPropertyFile();
        if (this.modelPackage == null) {
            this.modelPackage = this.getProperty("ge.model.package");
        }
        if (StrKit.isBlank((String)this.modelPackage)) {
            throw new IllegalArgumentException("Please set your model package in cfg.txt file");
        }
        return this.modelPackage;
    }
}

