/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.config;

import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.ext2.config.JFinalConfigExt;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import java.util.List;

public class StandaloneDbConfig {
    private static StandaloneDbConfig instance = null;
    private JFinalSubConfig cfg = null;

    private StandaloneDbConfig(boolean geRuned) {
        this.cfg = new JFinalSubConfig(geRuned);
        this.cfg.start();
    }

    public static void start() {
        if (instance == null) {
            instance = new StandaloneDbConfig(true);
        }
    }

    public static void startGe() {
        if (instance == null) {
            instance = new StandaloneDbConfig(false);
        }
    }

    public static void stop() {
        if (instance != null) {
            StandaloneDbConfig.instance.cfg.stop();
        }
    }

    private static class JFinalSubConfig
    extends JFinalConfigExt {
        private static final Plugins plugins = new Plugins();

        public JFinalSubConfig(boolean geRuned) {
            this.geRuned = geRuned;
            this.configPlugin(plugins);
        }

        public void start() {
            this.startPlugins();
        }

        public void stop() {
            this.stopPlugins();
        }

        private void startPlugins() {
            List pluginList = plugins.getPluginList();
            if (pluginList == null) {
                return;
            }
            for (IPlugin plugin : pluginList) {
                try {
                    if (plugin.start()) continue;
                    String message = "Plugin start error: " + plugin.getClass().getName();
                    throw new RuntimeException(message);
                }
                catch (Exception e) {
                    String message = "Plugin start error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                    throw new RuntimeException(message, e);
                }
            }
        }

        private void stopPlugins() {
            List pluginList = plugins.getPluginList();
            if (pluginList == null) {
                return;
            }
            for (IPlugin plugin : pluginList) {
                try {
                    if (plugin.stop()) continue;
                    String message = "Plugin stop error: " + plugin.getClass().getName();
                    throw new RuntimeException(message);
                }
                catch (Exception e) {
                    String message = "Plugin stop error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                    throw new RuntimeException(message, e);
                }
            }
        }

        @Override
        public void configMoreConstants(Constants me) {
        }

        @Override
        public void configMoreRoutes(Routes me) {
        }

        @Override
        public void configMorePlugins(Plugins me) {
        }

        @Override
        public void configTablesMapping(String configName, ActiveRecordPlugin arp) {
        }

        @Override
        public void configMoreInterceptors(Interceptors me) {
        }

        @Override
        public void configMoreHandlers(Handlers me) {
        }

        @Override
        public void afterJFinalStarted() {
        }
    }
}

