/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.kit;

import java.io.UnsupportedEncodingException;

public final class EncodingKit {
    public static final String US_ASCII = "US-ASCII";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_16 = "UTF-16";
    public static final String GBK = "GBK";

    public static String toASCII(String str) {
        return EncodingKit.changeCharset(str, US_ASCII);
    }

    public static String toISO_8859_1(String str) {
        return EncodingKit.changeCharset(str, ISO_8859_1);
    }

    public static String toUTF_8(String str) {
        return EncodingKit.changeCharset(str, UTF_8);
    }

    public static String toUTF_16BE(String str) {
        return EncodingKit.changeCharset(str, UTF_16BE);
    }

    public static String toUTF_16LE(String str) {
        return EncodingKit.changeCharset(str, UTF_16LE);
    }

    public static String toUTF_16(String str) {
        return EncodingKit.changeCharset(str, UTF_16);
    }

    public static String toGBK(String str) {
        return EncodingKit.changeCharset(str, GBK);
    }

    public static String changeCharset(String str, String newCharset) {
        if (str != null) {
            byte[] bs = str.getBytes();
            try {
                return new String(bs, newCharset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }

    public static String changeCharset(String str, String oldCharset, String newCharset) {
        if (str != null) {
            try {
                byte[] bs = str.getBytes(oldCharset);
                return new String(bs, newCharset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }
}

