/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.kit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import java.util.HashMap;
import java.util.Map;

public final class JsonExtKit {
    private static Log log = Log.getLog(JsonExtKit.class);

    public static JSONObject jsonToObject(String json) {
        return JSON.parseObject((String)json);
    }

    public static JSONArray jsonToJSONArray(String json) {
        return JSON.parseArray((String)json);
    }

    public static Object[] jsonToObjArray(String json) {
        return JsonExtKit.jsonToJSONArray(json).toArray();
    }

    public static <K, V> Map<K, V> jsonToMap(String json) {
        JSONObject obj = JsonExtKit.jsonToObject(json);
        HashMap map = new HashMap();
        for (Object key : obj.keySet()) {
            Map<K, V> value = obj.get(key);
            if (value instanceof JSONObject) {
                value = JsonExtKit.jsonToMap(((JSONObject)value).toJSONString());
            }
            map.put(key, value);
        }
        return map;
    }

    public static <T extends Model<T>> Model<T> jsonToModel(String json, Class<T> clazz) {
        Model model = null;
        try {
            model = (Model)clazz.newInstance();
        }
        catch (InstantiationException e) {
            log.error(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage());
        }
        Map attrs = JsonExtKit.jsonToMap(json);
        return model._setAttrs(attrs);
    }

    public static Record jsonToRecord(String json) {
        Map map = JsonExtKit.jsonToMap(json);
        return new Record().setColumns(map);
    }
}

