/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.kit;

import com.jfinal.kit.HashKit;
import java.util.Random;
import java.util.UUID;

public final class RandomKit {
    public static String smsAuthCode(int codeLen) {
        return RandomKit.smsAuthCode(codeLen, SMSAuthCodeType.Numbers);
    }

    public static String smsAuthCode(int codeLen, SMSAuthCodeType type) {
        String randomCode = "";
        String strTable = type == SMSAuthCodeType.Numbers ? "1234567890" : "1234567890abcdefghijkmnpqrstuvwxyz";
        int len = strTable.length();
        boolean bDone = true;
        do {
            randomCode = "";
            int count = 0;
            int i = 0;
            while (i < codeLen) {
                double dblR = Math.random() * (double)len;
                int intR = (int)Math.floor(dblR);
                char c = strTable.charAt(intR);
                if ('0' <= c && c <= '9') {
                    ++count;
                }
                randomCode = String.valueOf(randomCode) + strTable.charAt(intR);
                ++i;
            }
            if (count < 2) continue;
            bDone = false;
        } while (bDone);
        return randomCode.toUpperCase();
    }

    public static int random(int min, int max) {
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static String randomStr() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String randomMD5Str() {
        return HashKit.md5((String)RandomKit.randomStr());
    }

    public static enum SMSAuthCodeType {
        Numbers,
        CharAndNumbers;

    }
}

