/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.kit;

public final class SqlKit {
    public static final String select = "SELECT";
    public static final String update = "UPDATE";
    public static final String set = "SET";
    public static final String insert = "INSERT INTO";
    public static final String values = "VALUES";
    public static final String from = "FROM";
    public static final String where = "WHERE";
    public static final String like = "LIKE";
    public static final String and = "AND";
    public static final String or = "OR";
    public static final String orderby = "ORDER BY";
    public static final String limit = "LIMIT";
    private static final String sapce = " ";
    private StringBuilder sql = new StringBuilder();

    private SqlKit orderBy(String condition, ORDER order) {
        this.sql.append(orderby).append(sapce).append(condition).append(sapce).append(order.toString());
        return this;
    }

    public SqlKit select(String ... selects) {
        this.sql.append(select).append(sapce);
        int index = 0;
        String[] stringArray = selects;
        int n = selects.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.sql.append(string);
            if (index != selects.length - 1) {
                this.sql.append(",").append(sapce);
            } else {
                this.sql.append(sapce);
            }
            ++index;
            ++n2;
        }
        return this;
    }

    public Column column(String col, String as) {
        return new Column(col, as);
    }

    public SqlKit select(Column ... cols) {
        this.sql.append(select).append(sapce);
        int index = 0;
        Column[] columnArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            Column col = columnArray[n2];
            this.sql.append(col.column());
            if (index != cols.length - 1) {
                this.sql.append(",").append(sapce);
            } else {
                this.sql.append(sapce);
            }
            ++index;
            ++n2;
        }
        return this;
    }

    public SqlKit update(String tableName) {
        this.sql.append(update).append(sapce).append(tableName).append(sapce);
        return this;
    }

    public SqlKit set(Object ... columnsValues) {
        int len = columnsValues.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for set, columnsValues length can not be odd");
        }
        this.sql.append(set).append(sapce);
        StringBuilder column = null;
        int index = 0;
        while (index < len) {
            column = new StringBuilder();
            if (index % 2 == 0) {
                column.append(columnsValues[index]).append(sapce).append("=");
            } else {
                column.append(columnsValues[index]);
                if (index != len - 1) {
                    column.append(",");
                }
            }
            this.sql.append((CharSequence)column).append(sapce);
            ++index;
        }
        return this;
    }

    public SqlKit insert(String tableName) {
        this.sql.append(insert).append(sapce).append(tableName).append(sapce);
        return this;
    }

    public SqlKit values(Object ... columnsValues) {
        int len = columnsValues.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for values, columnsValues length can not be odd");
        }
        this.sql.append(values).append(sapce);
        this.sql.append("(").append(sapce);
        StringBuilder column = null;
        int index = 0;
        while (index < len) {
            column = new StringBuilder();
            if (index % 2 == 0) {
                column.append(columnsValues[index]).append(sapce).append("=");
            } else {
                column.append(columnsValues[index]);
                if (index != len - 1) {
                    column.append(",");
                }
            }
            this.sql.append((CharSequence)column).append(sapce);
            ++index;
        }
        this.sql.append(")");
        return this;
    }

    public SqlKit from(String ... tableNames) {
        this.sql.append(from).append(sapce);
        int index = 0;
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.sql.append(string);
            if (index != tableNames.length - 1) {
                this.sql.append(",").append(sapce);
            } else {
                this.sql.append(sapce);
            }
            ++index;
            ++n2;
        }
        return this;
    }

    public SqlKit where(String where) {
        this.sql.append(where).append(sapce).append(where).append(sapce);
        return this;
    }

    public SqlKit like(String like) {
        throw new IllegalArgumentException("not finished");
    }

    public SqlKit and(String condition) {
        this.sql.append(and).append(sapce).append(condition).append(sapce);
        return this;
    }

    public SqlKit or(String condition) {
        this.sql.append(or).append(sapce).append(condition).append(sapce);
        return this;
    }

    public SqlKit ascOrderBy(String condition) {
        return this.orderBy(condition, ORDER.ASC);
    }

    public SqlKit descOrderBy(String condition) {
        return this.orderBy(condition, ORDER.DESC);
    }

    public SqlKit limit(String ... params) {
        if (params.length > 2) {
            throw new IllegalArgumentException("more params");
        }
        this.sql.append(sapce).append(limit).append(sapce);
        int index = 0;
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            this.sql.append(param);
            if (index != params.length - 1) {
                this.sql.append(",").append(sapce);
            } else {
                this.sql.append(sapce);
            }
            ++index;
            ++n2;
        }
        return this;
    }

    public SqlKit append(String append) {
        this.sql.append(append);
        return this;
    }

    public String sql() {
        String _sql = this.sql.toString();
        if (!_sql.endsWith(";")) {
            this.sql.append(";");
            return this.sql.toString();
        }
        return _sql;
    }

    public static class Column {
        private String colName = null;
        private String as = null;

        public Column(String colName, String as) {
            this.colName = colName;
            this.as = as;
        }

        public String column() {
            return this.colName + SqlKit.sapce + this.as;
        }
    }

    private static enum ORDER {
        DESC,
        ASC;

    }
}

